/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.io.metadata.collectearth.balloon;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.openforis.collect.earth.core.handlers.BalloonInputFieldsUtils;
import org.openforis.collect.io.metadata.collectearth.balloon.CEAncillaryFields;
import org.openforis.collect.io.metadata.collectearth.balloon.CECodeField;
import org.openforis.collect.io.metadata.collectearth.balloon.CEComponent;
import org.openforis.collect.io.metadata.collectearth.balloon.CEComponentHTMLFormatter;
import org.openforis.collect.io.metadata.collectearth.balloon.CEEnumeratedEntityTable;
import org.openforis.collect.io.metadata.collectearth.balloon.CEEnumeratingCodeField;
import org.openforis.collect.io.metadata.collectearth.balloon.CEField;
import org.openforis.collect.io.metadata.collectearth.balloon.CEFieldSet;
import org.openforis.collect.io.metadata.collectearth.balloon.CETab;
import org.openforis.collect.io.metadata.collectearth.balloon.CETabSet;
import org.openforis.collect.io.metadata.collectearth.balloon.CETableRow;
import org.openforis.collect.io.metadata.collectearth.balloon.HtmlUnicodeEscaperUtil;
import org.openforis.collect.io.metadata.collectearth.balloon.Messages;
import org.openforis.collect.metamodel.CollectAnnotations;
import org.openforis.collect.metamodel.ui.NodeDefinitionUIComponent;
import org.openforis.collect.metamodel.ui.UIConfiguration;
import org.openforis.collect.metamodel.ui.UIField;
import org.openforis.collect.metamodel.ui.UIForm;
import org.openforis.collect.metamodel.ui.UIFormComponent;
import org.openforis.collect.metamodel.ui.UIFormSection;
import org.openforis.collect.metamodel.ui.UIFormSet;
import org.openforis.collect.metamodel.ui.UIOptions;
import org.openforis.collect.metamodel.ui.UITable;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.utils.Numbers;
import org.openforis.idm.metamodel.AttributeDefinition;
import org.openforis.idm.metamodel.BooleanAttributeDefinition;
import org.openforis.idm.metamodel.CodeAttributeDefinition;
import org.openforis.idm.metamodel.CodeList;
import org.openforis.idm.metamodel.CodeListItem;
import org.openforis.idm.metamodel.CodeListService;
import org.openforis.idm.metamodel.CoordinateAttributeDefinition;
import org.openforis.idm.metamodel.DateAttributeDefinition;
import org.openforis.idm.metamodel.EntityDefinition;
import org.openforis.idm.metamodel.KeyAttributeDefinition;
import org.openforis.idm.metamodel.NodeDefinition;
import org.openforis.idm.metamodel.NodeDefinitionVisitor;
import org.openforis.idm.metamodel.NodeLabel;
import org.openforis.idm.metamodel.NumberAttributeDefinition;
import org.openforis.idm.metamodel.NumericAttributeDefinition;
import org.openforis.idm.metamodel.RangeAttributeDefinition;
import org.openforis.idm.metamodel.Schema;
import org.openforis.idm.metamodel.TextAttributeDefinition;
import org.openforis.idm.metamodel.TimeAttributeDefinition;

public class CollectEarthBalloonGenerator {
    public static final String EXTRA_HIDDEN_PREFIX = "EXTRA_";
    protected static final String EXTRA_HIDDEN_FIELD_CLASS = "extra";
    private static final Set<String> HIDDEN_ATTRIBUTE_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("operator", "location", "plot_file", "actively_saved", "actively_saved_on")));
    private static final String BALLOON_TEMPLATE_TXT = "org/openforis/collect/designer/templates/collectearth/balloon_template_new.txt";
    private static final String PLACEHOLDER_FOR_DYNAMIC_FIELDS = "PLACEHOLDER_FOR_DYNAMIC_FIELDS";
    private static final String PLACEHOLDER_FOR_FINISH_TRANSLATION = "PLACEHOLDER_FINISH";
    private static final String PLACEHOLDER_FOR_NEXT_TRANSLATION = "PLACEHOLDER_NEXT";
    private static final String PLACEHOLDER_FOR_PREVIOUS_TRANSLATION = "PLACEHOLDER_PREVIOUS";
    private static final String PLACEHOLDER_COLLECT_NOT_RUNNING = "PLACEHOLDER_COLLECT_NOT_RUNNING";
    private static final String PLACEHOLDER_PLACEMARK_ALREADY_FILLED = "PLACEHOLDER_PLACEMARK_ALREADY_FILLED";
    private static final String PLACEHOLDER_EXTRA_ID_ATTRIBUTES = "PLACEHOLDER_EXTRA_ID_ATTRIBUTES";
    private static final String PLACEHOLDER_UI_LANGUAGE = "PLACEHOLDER_UI_LANGUAGE";
    private static final String PLACEHOLDER_FOR_EXTRA_ID_GET_REQUEST = "PLACEHOLDER_FOR_EXTRA_ID_GET_REQUEST";
    private static final String PLACEHOLDER_PREVIEW = "PLACEHOLDER_PREVIEW";
    private static final String PLACEHOLDER_RANDOM_NUMBER = "$[randomNumber]";
    private CollectSurvey survey;
    private String language;
    private boolean preview;
    private Map<String, CEComponent> componentByName;
    private BalloonInputFieldsUtils balloonInputFieldsUtils;
    private Map<String, String> htmlParameterNameByNodePath;

    public CollectEarthBalloonGenerator(CollectSurvey survey, String language) {
        this(survey, language, false);
    }

    public CollectEarthBalloonGenerator(CollectSurvey survey, String language, boolean preview) {
        this.survey = survey;
        this.language = language;
        this.preview = preview;
        this.componentByName = new HashMap<String, CEComponent>();
        this.balloonInputFieldsUtils = new BalloonInputFieldsUtils();
        this.htmlParameterNameByNodePath = this.balloonInputFieldsUtils.getHtmlParameterNameByNodePath(this.getRootEntity());
    }

    public String generateHTML() throws IOException {
        String result = this.getHTMLTemplate();
        if (this.preview) {
            result = this.replaceHostForPreview(result);
        }
        result = this.addHiddenFields(result);
        result = this.fillWithSurveyDefinitionFields(result);
        result = this.replaceButtonLocalizationText(result);
        return result;
    }

    private String replaceHostForPreview(String html) {
        return html.replaceAll("\\$\\[host\\]", "preview_");
    }

    private String replaceButtonLocalizationText(String htmlForBalloon) {
        htmlForBalloon = htmlForBalloon.replace(PLACEHOLDER_FOR_FINISH_TRANSLATION, HtmlUnicodeEscaperUtil.escapeHtmlUnicode(Messages.getString("CollectEarthBalloonGenerator.11", this.language)));
        htmlForBalloon = htmlForBalloon.replace(PLACEHOLDER_FOR_NEXT_TRANSLATION, HtmlUnicodeEscaperUtil.escapeHtmlUnicode(Messages.getString("CollectEarthBalloonGenerator.12", this.language)));
        htmlForBalloon = htmlForBalloon.replace(PLACEHOLDER_FOR_PREVIOUS_TRANSLATION, HtmlUnicodeEscaperUtil.escapeHtmlUnicode(Messages.getString("CollectEarthBalloonGenerator.13", this.language)));
        htmlForBalloon = htmlForBalloon.replace(PLACEHOLDER_COLLECT_NOT_RUNNING, HtmlUnicodeEscaperUtil.escapeHtmlUnicode(Messages.getString("CollectEarthBalloonGenerator.14", this.language)));
        htmlForBalloon = htmlForBalloon.replace(PLACEHOLDER_PLACEMARK_ALREADY_FILLED, HtmlUnicodeEscaperUtil.escapeHtmlUnicode(Messages.getString("CollectEarthBalloonGenerator.15", this.language)));
        htmlForBalloon = htmlForBalloon.replace(PLACEHOLDER_UI_LANGUAGE, this.language);
        htmlForBalloon = htmlForBalloon.replace(PLACEHOLDER_EXTRA_ID_ATTRIBUTES, this.getIdAttributesSurvey());
        htmlForBalloon = htmlForBalloon.replace(PLACEHOLDER_FOR_EXTRA_ID_GET_REQUEST, this.getIdPlaceholdersSurvey());
        htmlForBalloon = htmlForBalloon.replace(PLACEHOLDER_PREVIEW, String.valueOf(this.preview).toLowerCase(Locale.ENGLISH));
        htmlForBalloon = htmlForBalloon.replace(PLACEHOLDER_RANDOM_NUMBER, String.valueOf(Numbers.randomInt((int)10000, (int)5000000)));
        return htmlForBalloon;
    }

    private String getIdAttributesSurvey() {
        String jsArrayKeys = "[";
        List keyAttributeDefinitions = this.survey.getSchema().getFirstRootEntityDefinition().getKeyAttributeDefinitions();
        BalloonInputFieldsUtils balloonUtils = new BalloonInputFieldsUtils();
        for (AttributeDefinition keyAttribute : keyAttributeDefinitions) {
            jsArrayKeys = jsArrayKeys + "'" + balloonUtils.getCollectBalloonParamName((NodeDefinition)keyAttribute) + "',";
        }
        jsArrayKeys = jsArrayKeys.substring(0, jsArrayKeys.lastIndexOf(","));
        jsArrayKeys = jsArrayKeys + "]";
        return jsArrayKeys;
    }

    private String getIdPlaceholdersSurvey() {
        List keyAttributeDefinitions = this.survey.getSchema().getFirstRootEntityDefinition().getKeyAttributeDefinitions();
        StringBuilder sb = new StringBuilder();
        for (AttributeDefinition def : keyAttributeDefinitions) {
            sb.append(def.getName()).append("=").append("$[").append(EXTRA_HIDDEN_PREFIX).append(def.getName()).append("]").append("&");
        }
        return (String)sb.subSequence(0, sb.length() - 1);
    }

    private String getHTMLTemplate() throws IOException {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(BALLOON_TEMPLATE_TXT);
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)is, (Writer)writer, (String)"UTF-8");
        String template = writer.toString();
        return template;
    }

    private String fillWithSurveyDefinitionFields(String template) {
        CEComponentHTMLFormatter htmlFormatter = new CEComponentHTMLFormatter(this.language);
        CETabSet rootComponent = this.generateRootComponent();
        StringBuilder sb = new StringBuilder();
        String dynamicFieldsHtml = htmlFormatter.format(rootComponent);
        sb.append(dynamicFieldsHtml);
        String result = template.replace(PLACEHOLDER_FOR_DYNAMIC_FIELDS, sb.toString());
        return result;
    }

    private String addHiddenFields(String templateContent) {
        List<AttributeDefinition> nodesFromCSV = this.getHiddenNodeDefinitions();
        StringBuilder sb = new StringBuilder();
        for (AttributeDefinition def : nodesFromCSV) {
            String name = this.getHtmlParameterName((NodeDefinition)def);
            sb.append("<input type=\"hidden\" id=\"");
            sb.append(name);
            sb.append("\" name=\"");
            sb.append(name);
            sb.append("\" value=\"$[");
            sb.append(EXTRA_HIDDEN_PREFIX);
            sb.append(def.getName());
            sb.append("]\"");
            sb.append(" class=\"");
            sb.append(EXTRA_HIDDEN_FIELD_CLASS);
            sb.append("\"");
            sb.append(" />");
            sb.append('\n');
        }
        String result = templateContent.replace("PLACEHOLDER_FOR_EXTRA_CSV_DATA", sb.toString());
        return result;
    }

    private List<AttributeDefinition> getHiddenNodeDefinitions() {
        final ArrayList<AttributeDefinition> nodesFromCSV = new ArrayList<AttributeDefinition>();
        final CollectAnnotations annotations = this.survey.getAnnotations();
        Schema schema = this.survey.getSchema();
        schema.traverse(new NodeDefinitionVisitor(){

            public void visit(NodeDefinition definition) {
                AttributeDefinition attrDef;
                if (definition instanceof AttributeDefinition && (annotations.isFromCollectEarthCSV(attrDef = (AttributeDefinition)definition) && !annotations.isShowReadOnlyFieldInCollectEarth(attrDef) || attrDef.isKey() && definition.getParentEntityDefinition().isRoot())) {
                    nodesFromCSV.add(attrDef);
                }
            }
        });
        return nodesFromCSV;
    }

    private CETabSet generateRootComponent() {
        EntityDefinition rootEntityDef = this.getRootEntity();
        UIOptions uiOptions = this.survey.getUIOptions();
        UIConfiguration uiConfiguration = this.survey.getUIConfiguration();
        if (uiConfiguration == null) {
            throw new IllegalStateException("Error unmarshalling the survey - no UI configruration!");
        }
        if (uiConfiguration.getFormSets().isEmpty()) {
            CETabSet tabSet = new CETabSet("", "");
            CETab tab = new CETab(rootEntityDef.getName(), "");
            for (NodeDefinition childDef : rootEntityDef.getChildDefinitions()) {
                if (uiOptions.isHidden(childDef)) continue;
                tab.addChild(this.createComponent(childDef));
            }
            tabSet.addTab(tab);
            return tabSet;
        }
        CETabSet tabSet = new CETabSet("", "");
        UIFormSet formSet = uiConfiguration.getMainFormSet();
        for (UIForm form : formSet.getForms()) {
            boolean main = tabSet.getTabs().isEmpty();
            CETab tab = this.createTabComponent(rootEntityDef, form, main);
            tabSet.addTab(tab);
        }
        return tabSet;
    }

    private CETab createTabComponent(EntityDefinition rootEntityDef, UIForm form, boolean main) {
        CollectAnnotations annotations = this.survey.getAnnotations();
        String label = form.getLabel(this.language, this.survey.getDefaultLanguage());
        CETab tab = new CETab(rootEntityDef.getName(), label);
        tab.setMain(main);
        for (UIFormComponent formComponent : form.getChildren()) {
            if (!(formComponent instanceof NodeDefinitionUIComponent)) continue;
            NodeDefinition nodeDef = ((NodeDefinitionUIComponent)formComponent).getNodeDefinition();
            if (formComponent instanceof UIField) {
                AttributeDefinition attrDef = ((UIField)formComponent).getAttributeDefinition();
                String nodeName = nodeDef.getName();
                boolean includeInHTML = !HIDDEN_ATTRIBUTE_NAMES.contains(nodeName) && (!annotations.isFromCollectEarthCSV(attrDef) || annotations.isShowReadOnlyFieldInCollectEarth(attrDef)) && !((UIField)formComponent).isHidden() && !((UIField)formComponent).getAttributeDefinition().isKey();
                boolean includeAsAncillaryData = annotations.isIncludedInCollectEarthHeader((AttributeDefinition)nodeDef);
                if (includeInHTML) {
                    CEComponent component = this.createComponent(nodeDef);
                    tab.addChild(component);
                    continue;
                }
                if (!includeAsAncillaryData) continue;
                CEAncillaryFields ancillaryDataHeader = tab.getAncillaryDataHeader();
                if (ancillaryDataHeader == null) {
                    ancillaryDataHeader = new CEAncillaryFields("ancillary_data", "Ancillary data");
                    tab.setAncillaryDataHeader(ancillaryDataHeader);
                }
                CEComponent component = this.createComponent(nodeDef);
                ancillaryDataHeader.addChild(component);
                continue;
            }
            if (formComponent instanceof UITable || formComponent instanceof UIFormSection) {
                CEComponent component = this.createComponent(nodeDef);
                tab.addChild(component);
                continue;
            }
            throw new IllegalArgumentException("Form component not supported: " + formComponent.getClass().getName());
        }
        return tab;
    }

    private EntityDefinition getRootEntity() {
        return this.survey.getSchema().getFirstRootEntityDefinition();
    }

    private CEComponent createComponent(NodeDefinition def) {
        return this.createComponent(def, 1);
    }

    private CEComponent createComponent(NodeDefinition def, int entityPosition) {
        CEComponent comp;
        String label = def.getLabel(NodeLabel.Type.INSTANCE, this.language);
        if (label == null && !this.isDefaultLanguage()) {
            label = def.getLabel(NodeLabel.Type.INSTANCE);
        }
        if (label == null) {
            label = def.getName();
        }
        boolean multiple = def.isMultiple();
        UIOptions uiOptions = this.survey.getUIOptions();
        boolean hideWhenNotRelevant = uiOptions.isHideWhenNotRelevant(def);
        if (def instanceof EntityDefinition) {
            if (def.isMultiple() && ((EntityDefinition)def).isEnumerable()) {
                comp = this.createEnumeratedEntityComponent((EntityDefinition)def);
            } else {
                String tooltip = def.getDescription(this.language);
                CEFieldSet fieldSet = new CEFieldSet(def.getName(), label, tooltip);
                for (NodeDefinition child : ((EntityDefinition)def).getChildDefinitions()) {
                    if (uiOptions.isHidden(child)) continue;
                    fieldSet.addChild(this.createComponent(child));
                }
                comp = fieldSet;
            }
        } else {
            boolean key;
            AttributeDefinition attrDef = (AttributeDefinition)def;
            EntityDefinition parentEntityDef = def.getParentEntityDefinition();
            boolean insideEnumeratedEntity = parentEntityDef.isEnumerable();
            String htmlParameterName = insideEnumeratedEntity ? this.getEnumeratedEntityComponentHtmlParameterName(parentEntityDef, entityPosition, def) : this.getHtmlParameterName(def);
            String tooltip = attrDef.getDescription(this.language);
            CEField.CEFieldType type = this.getFieldType(def);
            boolean bl = key = def instanceof KeyAttributeDefinition ? ((KeyAttributeDefinition)def).isKey() : false;
            if (insideEnumeratedEntity && key) {
                comp = new CEEnumeratingCodeField(htmlParameterName, def.getName(), label, tooltip, multiple, type, key);
            } else if (def instanceof CodeAttributeDefinition) {
                CodeAttributeDefinition codeAttrDef = (CodeAttributeDefinition)def;
                CodeList list = codeAttrDef.getList();
                Integer listLevelIndex = codeAttrDef.getListLevelIndex();
                Map<Integer, List<CodeListItem>> codeItemsByParentCodeItemId = this.getCodeListItemsByParentId(list, listLevelIndex);
                String parentName = this.getParentCodeParameterName(parentEntityDef, entityPosition, codeAttrDef);
                comp = new CECodeField(htmlParameterName, def.getName(), label, tooltip, type, multiple, key, codeItemsByParentCodeItemId, parentName);
            } else {
                comp = new CEField(htmlParameterName, def.getName(), label, tooltip, multiple, type, key);
            }
            CollectAnnotations annotations = this.survey.getAnnotations();
            if (annotations.isFromCollectEarthCSV(attrDef) && annotations.isShowReadOnlyFieldInCollectEarth(attrDef)) {
                ((CEField)comp).setReadOnly(true);
                ((CEField)comp).setExtra(true);
            }
            if (attrDef.isCalculated()) {
                ((CEField)comp).setReadOnly(true);
                ((CEField)comp).setCalculated(true);
            }
        }
        comp.hideWhenNotRelevant = hideWhenNotRelevant;
        this.componentByName.put(comp.getName(), comp);
        return comp;
    }

    private Map<Integer, List<CodeListItem>> getCodeListItemsByParentId(CodeList list, Integer listLevelIndex) {
        CodeListService codeListService = list.getSurvey().getContext().getCodeListService();
        HashMap<Integer, List<CodeListItem>> codeItemsByParentCodeItemId = new HashMap<Integer, List<CodeListItem>>();
        if (listLevelIndex == null || listLevelIndex == 0) {
            List rootCodeItems = codeListService.loadRootItems(list);
            codeItemsByParentCodeItemId.put(0, rootCodeItems);
        } else {
            int listLevelPosition = listLevelIndex + 1;
            List parentLevelItems = listLevelPosition == 2 ? codeListService.loadRootItems(list) : codeListService.loadItems(list, listLevelPosition - 1);
            for (CodeListItem parentItem : parentLevelItems) {
                List childItems = codeListService.loadChildItems(parentItem);
                if (childItems.isEmpty()) continue;
                codeItemsByParentCodeItemId.put(parentItem.getId(), childItems);
            }
        }
        return codeItemsByParentCodeItemId;
    }

    private CEComponent createEnumeratedEntityComponent(EntityDefinition def) {
        String label = def.getLabel(NodeLabel.Type.INSTANCE, this.language);
        if (label == null && !this.isDefaultLanguage()) {
            label = def.getLabel(NodeLabel.Type.INSTANCE);
        }
        if (label == null) {
            label = def.getName();
        }
        UIOptions uiOptions = this.survey.getUIOptions();
        String tableTooltip = def.getDescription(this.language);
        CEEnumeratedEntityTable ceTable = new CEEnumeratedEntityTable(def.getName(), label, tableTooltip);
        for (NodeDefinition child : def.getChildDefinitions()) {
            if (uiOptions.isHidden(child)) continue;
            String heading = child.getLabel(NodeLabel.Type.INSTANCE, this.language);
            if (heading == null && !this.isDefaultLanguage()) {
                heading = child.getLabel(NodeLabel.Type.INSTANCE);
            }
            if (heading == null) {
                heading = child.getName();
            }
            ceTable.addHeading(heading);
        }
        CodeAttributeDefinition enumeratingCodeAttribute = def.getEnumeratingKeyCodeAttribute();
        CodeListService codeListService = def.getSurvey().getContext().getCodeListService();
        List codeItems = codeListService.loadRootItems(enumeratingCodeAttribute.getList());
        int codeItemIdx = 0;
        for (CodeListItem item : codeItems) {
            String key = item.getCode();
            String itemLabel = CEComponentHTMLFormatter.getItemLabel(item, this.language);
            String tooltip = CEComponentHTMLFormatter.getDescription(item, this.language);
            CETableRow row = new CETableRow(key, itemLabel, tooltip);
            for (NodeDefinition child : def.getChildDefinitions()) {
                if (uiOptions.isHidden(child)) continue;
                row.addChild(this.createComponent(child, codeItemIdx + 1));
            }
            ceTable.addRow(row);
            ++codeItemIdx;
        }
        return ceTable;
    }

    private String getHtmlParameterName(NodeDefinition def) {
        return this.htmlParameterNameByNodePath.get(def.getPath());
    }

    private String getEnumeratedEntityComponentHtmlParameterName(EntityDefinition entityDef, int entityPosition, NodeDefinition childDef) {
        String nodePath = entityDef.getPath() + "[" + entityPosition + "]/" + childDef.getName();
        return this.htmlParameterNameByNodePath.get(nodePath);
    }

    private String getParentCodeParameterName(EntityDefinition parentDef, int entityPosition, CodeAttributeDefinition codeAttrDef) {
        CodeAttributeDefinition parentCodeAttrDef = codeAttrDef.getParentCodeAttributeDefinition();
        if (parentCodeAttrDef == null) {
            return null;
        }
        EntityDefinition parentCodeAttributeDefParentEntity = parentCodeAttrDef.getParentEntityDefinition();
        if (parentCodeAttributeDefParentEntity.equals((Object)parentDef) && parentCodeAttributeDefParentEntity.isEnumerable()) {
            return this.getEnumeratedEntityComponentHtmlParameterName(parentDef, entityPosition, (NodeDefinition)parentCodeAttrDef);
        }
        return this.getHtmlParameterName((NodeDefinition)parentCodeAttrDef);
    }

    private CEField.CEFieldType getFieldType(NodeDefinition def) {
        if (def instanceof BooleanAttributeDefinition) {
            return CEField.CEFieldType.BOOLEAN;
        }
        if (def instanceof CodeAttributeDefinition) {
            UIOptions uiOptions = ((CollectSurvey)def.getSurvey()).getUIOptions();
            UIOptions.CodeAttributeLayoutType layoutType = uiOptions.getLayoutType((CodeAttributeDefinition)def);
            switch (layoutType) {
                case DROPDOWN: {
                    return CEField.CEFieldType.CODE_SELECT;
                }
            }
            return CEField.CEFieldType.CODE_BUTTON_GROUP;
        }
        if (def instanceof CoordinateAttributeDefinition) {
            return CEField.CEFieldType.COORDINATE;
        }
        if (def instanceof DateAttributeDefinition) {
            return CEField.CEFieldType.DATE;
        }
        if (def instanceof NumberAttributeDefinition) {
            if (((NumericAttributeDefinition)def).getType() == NumericAttributeDefinition.Type.INTEGER) {
                return CEField.CEFieldType.INTEGER;
            }
            return CEField.CEFieldType.REAL;
        }
        if (def instanceof TextAttributeDefinition) {
            if (((TextAttributeDefinition)def).getType() == TextAttributeDefinition.Type.SHORT) {
                return CEField.CEFieldType.SHORT_TEXT;
            }
            return CEField.CEFieldType.LONG_TEXT;
        }
        if (def instanceof TimeAttributeDefinition) {
            return CEField.CEFieldType.TIME;
        }
        if (def instanceof RangeAttributeDefinition) {
            if (((RangeAttributeDefinition)def).getType().equals((Object)NumericAttributeDefinition.Type.INTEGER)) {
                return CEField.CEFieldType.CODE_RANGE;
            }
            throw new IllegalArgumentException("REAL TYPE RANGES NOT SUPPRTED YET!");
        }
        throw new IllegalArgumentException("Attribute type not supported: " + def.getClass().getName());
    }

    private boolean isDefaultLanguage() {
        return this.language.equals(this.survey.getDefaultLanguage());
    }
}

