/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.remoting.service.dataimport;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.openforis.collect.Proxy;
import org.openforis.collect.ProxyContext;
import org.openforis.collect.io.data.DataImportSummaryItem;
import org.openforis.collect.model.CollectRecord;
import org.openforis.collect.model.CollectRecordSummary;
import org.openforis.collect.model.proxy.RecordSummaryProxy;
import org.openforis.collect.persistence.xml.NodeUnmarshallingError;
import org.openforis.collect.remoting.service.dataimport.NodeUnmarshallingErrorProxy;
import org.openforis.collect.utils.Numbers;

public class DataImportSummaryItemProxy
implements Proxy {
    private transient DataImportSummaryItem item;
    private transient Locale locale;

    public DataImportSummaryItemProxy(DataImportSummaryItem item, Locale locale) {
        this.item = item;
        this.locale = locale;
    }

    public static List<DataImportSummaryItemProxy> fromList(List<DataImportSummaryItem> items, Locale locale) {
        ArrayList<DataImportSummaryItemProxy> result = new ArrayList<DataImportSummaryItemProxy>();
        if (items != null) {
            for (DataImportSummaryItem item : items) {
                DataImportSummaryItemProxy proxy = new DataImportSummaryItemProxy(item, locale);
                result.add(proxy);
            }
        }
        return result;
    }

    public int getEntryId() {
        return this.item.getEntryId();
    }

    public RecordSummaryProxy getRecord() {
        return this.createRecordSummaryProxy(this.item.getRecordSummary(), this.locale);
    }

    public int getRecordTotalErrors() {
        return this.item.getRecordSummary() == null ? -1 : Numbers.toInt((Integer)this.item.getRecordSummary().getCurrentStepSummary().getTotalErrors(), (int)-1);
    }

    public int getRecordErrors() {
        return this.item.getRecordSummary() == null ? -1 : Numbers.toInt((Integer)this.item.getRecordSummary().getCurrentStepSummary().getErrors(), (int)-1);
    }

    public int getRecordMissingErrors() {
        return this.item.getRecordSummary() == null ? -1 : Numbers.toInt((Integer)this.item.getRecordSummary().getCurrentStepSummary().getMissingErrors(), (int)-1);
    }

    public Date getRecordCreationDate() {
        return this.item.getRecordSummary() == null ? null : this.item.getRecordSummary().getCreationDate();
    }

    public Date getRecordModifiedDate() {
        return this.item.getRecordSummary() == null ? null : this.item.getRecordSummary().getCreationDate();
    }

    public int getRecordCompletionPercent() {
        return this.item.getRecordCompletionPercent();
    }

    public int getRecordFilledAttributesCount() {
        return this.item.getRecordFilledAttributesCount();
    }

    public RecordSummaryProxy getConflictingRecord() {
        return this.createRecordSummaryProxy(this.item.getConflictingRecordSummary(), this.locale);
    }

    public int getConflictingRecordTotalErrors() {
        CollectRecordSummary conflictingRecord = this.item.getConflictingRecordSummary();
        return conflictingRecord == null ? -1 : Numbers.toInt((Integer)conflictingRecord.getCurrentStepSummary().getTotalErrors(), (int)-1);
    }

    public int getConflictingRecordErrors() {
        CollectRecordSummary conflictingRecord = this.item.getConflictingRecordSummary();
        return conflictingRecord == null ? -1 : Numbers.toInt((Integer)conflictingRecord.getCurrentStepSummary().getErrors(), (int)-1);
    }

    public int getConflictingRecordMissingErrors() {
        CollectRecordSummary conflictingRecord = this.item.getConflictingRecordSummary();
        return conflictingRecord == null ? -1 : Numbers.toInt((Integer)conflictingRecord.getCurrentStepSummary().getMissingErrors(), (int)-1);
    }

    public int getConflictingRecordCompletionPercent() {
        return this.item.getConflictingRecordCompletionPercent();
    }

    public Date getConflictingRecordCreationDate() {
        return this.item.getConflictingRecordSummary() == null ? null : this.item.getConflictingRecordSummary().getCreationDate();
    }

    public Date getConflictingRecordModifiedDate() {
        return this.item.getConflictingRecordSummary() == null ? null : this.item.getConflictingRecordSummary().getCreationDate();
    }

    public CollectRecord.Step getConflictingRecordStep() {
        return this.item.getConflictingRecordSummary() == null ? null : this.item.getConflictingRecordSummary().getStep();
    }

    public int getConflictingRecordFilledAttributesCount() {
        return this.item.getConflictingRecordFilledAttributesCount();
    }

    public int getCompletionDifferencePercent() {
        return this.item.calculateCompletionDifferencePercent();
    }

    public int getImportabilityLevel() {
        return this.item.calculateImportabilityLevel();
    }

    public List<NodeUnmarshallingErrorProxy> getWarnings() {
        ArrayList<NodeUnmarshallingError> result = new ArrayList<NodeUnmarshallingError>();
        Map warnings = this.item.getWarnings();
        if (warnings != null) {
            Set steps = warnings.keySet();
            for (CollectRecord.Step step : steps) {
                List warningsPerStep = (List)warnings.get(step);
                result.addAll(warningsPerStep);
            }
        }
        List<NodeUnmarshallingErrorProxy> proxies = NodeUnmarshallingErrorProxy.fromList(result);
        return proxies;
    }

    public List<CollectRecord.Step> getSteps() {
        return this.item.getSteps();
    }

    public boolean isEntryDataPresent() {
        return this.hasStep(CollectRecord.Step.ENTRY);
    }

    public boolean isCleansingDataPresent() {
        return this.hasStep(CollectRecord.Step.CLEANSING);
    }

    public boolean isAnalysisDataPresent() {
        return this.hasStep(CollectRecord.Step.ANALYSIS);
    }

    public boolean isConflictingRecordEntryDataPresent() {
        return this.isConflictingRecordAfterStep(CollectRecord.Step.ENTRY);
    }

    public boolean isConflictingRecordCleansingDataPresent() {
        return this.isConflictingRecordAfterStep(CollectRecord.Step.CLEANSING);
    }

    public boolean isConflictingRecordAnalysisDataPresent() {
        return this.isConflictingRecordAfterStep(CollectRecord.Step.ANALYSIS);
    }

    private RecordSummaryProxy createRecordSummaryProxy(CollectRecordSummary summary, Locale locale) {
        if (summary == null) {
            return null;
        }
        ProxyContext context = new ProxyContext(locale, null, null);
        return new RecordSummaryProxy(summary, context);
    }

    protected boolean hasStep(CollectRecord.Step step) {
        if (this.item.getSteps() != null) {
            return this.item.getSteps().contains(step);
        }
        return false;
    }

    private boolean isConflictingRecordAfterStep(CollectRecord.Step step) {
        CollectRecordSummary conflictingRecord = this.item.getConflictingRecordSummary();
        return conflictingRecord != null && conflictingRecord.getStep().afterEqual(step);
    }
}

