/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.remoting.service.dataimport;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.openforis.collect.Proxy;
import org.openforis.collect.io.data.DataImportSummary;
import org.openforis.collect.model.CollectRecord;
import org.openforis.collect.remoting.service.dataimport.DataImportSummaryItemProxy;
import org.openforis.collect.remoting.service.dataimport.FileUnmarshallingErrorProxy;

public class DataImportSummaryProxy
implements Proxy {
    private transient DataImportSummary summary;
    private Locale locale;

    public DataImportSummaryProxy(DataImportSummary summary, Locale locale) {
        this.summary = summary;
        this.locale = locale;
    }

    public List<FileUnmarshallingErrorProxy> getSkippedFileErrors() {
        List skippedFileErrors = this.summary.getSkippedFileErrors();
        List<FileUnmarshallingErrorProxy> proxies = FileUnmarshallingErrorProxy.fromList(skippedFileErrors);
        return proxies;
    }

    public String getSurveyName() {
        return this.summary.getSurveyName();
    }

    public Map<CollectRecord.Step, Integer> getTotalPerStep() {
        return this.summary.getTotalPerStep();
    }

    public List<DataImportSummaryItemProxy> getRecordsToImport() {
        return DataImportSummaryItemProxy.fromList(this.summary.getRecordsToImport(), this.locale);
    }

    public List<DataImportSummaryItemProxy> getConflictingRecords() {
        return DataImportSummaryItemProxy.fromList(this.summary.getConflictingRecords(), this.locale);
    }
}

