/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.viewmodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.openforis.collect.designer.form.CodeAttributeDefinitionFormObject;
import org.openforis.collect.designer.util.MessageUtil;
import org.openforis.collect.designer.util.Predicate;
import org.openforis.collect.designer.viewmodel.AttributeVM;
import org.openforis.collect.designer.viewmodel.BaseVM;
import org.openforis.collect.designer.viewmodel.SchemaObjectSelectorPopUpVM;
import org.openforis.collect.metamodel.CollectAnnotations;
import org.openforis.collect.metamodel.ui.UIOptions;
import org.openforis.collect.metamodel.ui.UITab;
import org.openforis.idm.metamodel.CodeAttributeDefinition;
import org.openforis.idm.metamodel.CodeList;
import org.openforis.idm.metamodel.CodeListLevel;
import org.openforis.idm.metamodel.EntityDefinition;
import org.openforis.idm.metamodel.SurveyObject;
import org.zkoss.bind.BindUtils;
import org.zkoss.bind.Binder;
import org.zkoss.bind.annotation.BindingParam;
import org.zkoss.bind.annotation.Command;
import org.zkoss.bind.annotation.ContextParam;
import org.zkoss.bind.annotation.ContextType;
import org.zkoss.bind.annotation.ExecutionArgParam;
import org.zkoss.bind.annotation.GlobalCommand;
import org.zkoss.bind.annotation.Init;
import org.zkoss.util.resource.Labels;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Window;

public class CodeAttributeVM
extends AttributeVM<CodeAttributeDefinition> {
    private static final String SHOW_ALLOWED_VALUES_PREVIEW_FIELD_NAME = "showAllowedValuesPreview";
    private static final String LAYOUT_DIRECTION_FIELD_NAME = "layoutDirection";
    private static final String CODE_LIST_ASSIGNED_COMMAND = "codeListAssigned";

    @Init(superclass=false)
    public void init(@ExecutionArgParam(value="parentEntity") EntityDefinition parentEntity, @ExecutionArgParam(value="item") CodeAttributeDefinition attributeDefn, @ExecutionArgParam(value="newItem") Boolean newItem) {
        super.initInternal(parentEntity, attributeDefn, newItem);
    }

    @Command
    public void onListChanged(@ContextParam(value=ContextType.BINDER) Binder binder, @BindingParam(value="list") CodeList list) {
        boolean listChanged;
        CodeAttributeDefinitionFormObject fo = (CodeAttributeDefinitionFormObject)this.getFormObject();
        CodeList oldList = fo.getList();
        boolean bl = listChanged = oldList != null && !oldList.equals((Object)list);
        if (oldList == null) {
            this.performListChange(binder, list);
        } else if (listChanged) {
            if (((CodeAttributeDefinition)this.editedItem).hasDependentCodeAttributeDefinitions()) {
                this.confirmParentCodeListChange(binder, list);
            } else {
                this.performListChange(binder, list);
            }
        }
    }

    private void confirmCodeListChange(final Binder binder, final CodeList list) {
        CodeList oldList = ((CodeAttributeDefinitionFormObject)this.getFormObject()).getList();
        MessageUtil.ConfirmParams confirmParams = new MessageUtil.ConfirmParams(new MessageUtil.ConfirmHandler(){

            @Override
            public void onOk() {
                CodeAttributeVM.this.performListChange(binder, list);
            }
        }, "survey.schema.attribute.code.confirm_change_list.message");
        confirmParams.setOkLabelKey("global.change");
        confirmParams.setCancelLabelKey("global.leave_original_value");
        confirmParams.setMessageArgs(new String[]{oldList.getName(), list.getName()});
        MessageUtil.showConfirm(confirmParams);
    }

    private void confirmParentCodeListChange(final Binder binder, final CodeList list) {
        MessageUtil.ConfirmParams confirmParams = new MessageUtil.ConfirmParams(new MessageUtil.CompleteConfirmHandler(){

            @Override
            public void onOk() {
                CodeAttributeVM.this.performListChange(binder, list);
            }

            @Override
            public void onCancel() {
                CodeList oldList = ((CodeAttributeDefinition)CodeAttributeVM.this.editedItem).getList();
                CodeAttributeVM.this.setFormFieldValue(binder, "list", (Object)oldList);
                CodeAttributeVM.this.setTempFormObjectFieldValue("list", oldList);
            }
        }, "survey.schema.attribute.code.confirm_change_list_on_referenced_node.message");
        confirmParams.setOkLabelKey("survey.schema.attribute.code.confirm_change_list_on_referenced_node.ok");
        confirmParams.setTitleKey("survey.schema.attribute.code.confirm_change_list_on_referenced_node.title");
        ArrayList<String> dependentAttributePaths = new ArrayList<String>();
        for (CodeAttributeDefinition codeAttributeDefinition : ((CodeAttributeDefinition)this.editedItem).getDependentCodeAttributeDefinitions()) {
            dependentAttributePaths.add(codeAttributeDefinition.getPath());
        }
        confirmParams.setMessageArgs(new String[]{StringUtils.join(dependentAttributePaths, (String)", ")});
        MessageUtil.showConfirm(confirmParams);
    }

    private void performListChange(Binder binder, CodeList list) {
        CodeAttributeDefinitionFormObject fo = (CodeAttributeDefinitionFormObject)this.getFormObject();
        CodeList oldList = fo.getList();
        fo.setParentCodeAttributeDefinition(null);
        fo.setList(list);
        this.setFormFieldValue(binder, "list", (Object)list);
        this.setFormFieldValue(binder, "list.hierarchical", (Object)(list != null && list.isHierarchical() ? 1 : 0));
        this.setFormFieldValue(binder, "parentCodeAttributeDefinitionPath", (Object)null);
        this.setFormFieldValue(binder, "hierarchicalLevel", (Object)null);
        this.dispatchApplyChangesCommand(binder);
        this.notifyChange("dependentCodePaths");
        this.dispatchCodeListAssignedCommand(list, oldList);
    }

    private void dispatchCodeListAssignedCommand(CodeList list, CodeList oldList) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("list", list);
        args.put("oldList", oldList);
        args.put("codeAttribute", this.editedItem);
        BindUtils.postGlobalCommand(null, null, (String)CODE_LIST_ASSIGNED_COMMAND, args);
    }

    @GlobalCommand
    public void codeListsPopUpClosed(@ContextParam(value=ContextType.BINDER) Binder binder, @BindingParam(value="editingAttribute") Boolean editingAttribute, @BindingParam(value="selectedCodeList") CodeList selectedCodeList) {
        if (editingAttribute.booleanValue() && selectedCodeList != null) {
            CodeAttributeDefinitionFormObject fo = (CodeAttributeDefinitionFormObject)this.getFormObject();
            CodeList oldList = fo.getList();
            if (oldList != null && !oldList.equals((Object)selectedCodeList)) {
                if (oldList != this.survey.getSamplingDesignCodeList()) {
                    this.confirmCodeListChange(binder, selectedCodeList);
                }
            } else {
                this.onListChanged(binder, selectedCodeList);
                this.validateForm(binder);
            }
        }
    }

    @Command
    public void openParentAttributeSelector(final @ContextParam(value=ContextType.BINDER) Binder binder) {
        String title = Labels.getLabel((String)"survey.schema.attribute.code.select_parent_for_node", (Object[])new String[]{((CodeAttributeDefinition)this.editedItem).getName()});
        final Collection assignableParentAttributes = ((CodeAttributeDefinition)this.editedItem).getAssignableParentCodeAttributeDefinitions();
        if (assignableParentAttributes.isEmpty()) {
            MessageUtil.showWarning("survey.schema.attribute.code.no_assignable_parent_available", new Object[0]);
        } else {
            CodeAttributeDefinition parentCodeAttributeDefinition = ((CodeAttributeDefinitionFormObject)this.formObject).getParentCodeAttributeDefinition();
            Predicate<SurveyObject> includedNodePredicate = new Predicate<SurveyObject>(){

                @Override
                public boolean evaluate(SurveyObject item) {
                    return item instanceof UITab || item instanceof EntityDefinition || item instanceof CodeAttributeDefinition && assignableParentAttributes.contains(item);
                }
            };
            Predicate<SurveyObject> disabledNodePredicate = new Predicate<SurveyObject>(){

                @Override
                public boolean evaluate(SurveyObject item) {
                    return !(item instanceof CodeAttributeDefinition);
                }
            };
            final Window parentSelectorPopUp = SchemaObjectSelectorPopUpVM.openPopup(title, false, ((CodeAttributeDefinition)this.editedItem).getRootEntity(), null, includedNodePredicate, false, false, disabledNodePredicate, null, (SurveyObject)parentCodeAttributeDefinition, true);
            parentSelectorPopUp.addEventListener("onNodeSelected", (EventListener)new EventListener<SchemaObjectSelectorPopUpVM.NodeSelectedEvent>(){

                public void onEvent(SchemaObjectSelectorPopUpVM.NodeSelectedEvent event) throws Exception {
                    CodeAttributeDefinition parentAttrDefn = (CodeAttributeDefinition)event.getSelectedItem();
                    CodeAttributeDefinitionFormObject fo = (CodeAttributeDefinitionFormObject)CodeAttributeVM.this.formObject;
                    fo.setParentCodeAttributeDefinition(parentAttrDefn);
                    String hierarchicalLevel = CodeAttributeVM.this.getHierarchicalLevelName(parentAttrDefn);
                    fo.setHierarchicalLevel(hierarchicalLevel);
                    CodeAttributeVM.this.notifyChange("formObject");
                    CodeAttributeVM.this.dispatchApplyChangesCommand(binder);
                    CodeAttributeVM.this.notifyChange("dependentCodePaths");
                    BaseVM.closePopUp(parentSelectorPopUp);
                }
            });
        }
    }

    private String getHierarchicalLevelName(CodeAttributeDefinition parentAttrDefn) {
        if (parentAttrDefn == null) {
            return null;
        }
        Integer parentLevelIndex = parentAttrDefn.getListLevelIndex();
        int levelIndex = parentLevelIndex + 1;
        CodeListLevel level = (CodeListLevel)parentAttrDefn.getList().getHierarchy().get(levelIndex);
        return level.getName();
    }

    @Command
    public void layoutTypeChange(@ContextParam(value=ContextType.BINDER) Binder binder, @BindingParam(value="layoutType") String layoutType) {
        this.setTempFormObjectFieldValue(SHOW_ALLOWED_VALUES_PREVIEW_FIELD_NAME, CollectAnnotations.Annotation.SHOW_ALLOWED_VALUES_PREVIEW.getDefaultValue());
        String layoutDirection = UIOptions.CodeAttributeLayoutType.RADIO.name().equals(layoutType) ? CollectAnnotations.Annotation.CODE_ATTRIBUTE_LAYOUT_DIRECTION.getDefaultValue().toString() : null;
        this.setTempFormObjectFieldValue(LAYOUT_DIRECTION_FIELD_NAME, layoutDirection);
        this.dispatchApplyChangesCommand(binder);
    }

    public String getDependentCodePaths() {
        if (this.newItem) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Collection dependents = ((CodeAttributeDefinition)this.editedItem).getDependentCodeAttributeDefinitions();
        Iterator it = dependents.iterator();
        while (it.hasNext()) {
            CodeAttributeDefinition dependent = (CodeAttributeDefinition)it.next();
            sb.append(dependent.getPath());
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }
}

