/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.web.controller;

import jakarta.validation.Valid;
import java.util.List;
import org.openforis.collect.manager.SessionManager;
import org.openforis.collect.manager.SurveyManager;
import org.openforis.collect.manager.UserManager;
import org.openforis.collect.model.SurveySummary;
import org.openforis.collect.model.User;
import org.openforis.collect.model.UserRole;
import org.openforis.collect.web.controller.AbstractPersistedObjectEditFormController;
import org.openforis.collect.web.validator.PasswordChangeValidator;
import org.openforis.collect.web.validator.UserValidator;
import org.openforis.commons.web.PersistedObjectForm;
import org.openforis.commons.web.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Validator;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/user"})
@Scope(value="session")
public class UserController
extends AbstractPersistedObjectEditFormController<Integer, User, UserForm, UserManager> {
    @Autowired
    private SurveyManager surveyManager;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private UserValidator userValidator;
    @Autowired
    private PasswordChangeValidator passwordChangeValidator;

    @InitBinder
    protected void initBinder(WebDataBinder binder) {
        if (binder.getTarget() instanceof UserForm) {
            binder.setValidator((Validator)this.userValidator);
        } else if (binder.getTarget() instanceof PasswordChangeParameters) {
            binder.setValidator((Validator)this.passwordChangeValidator);
        }
    }

    @RequestMapping(value={"{userId}/surveys/summaries.json"}, method={RequestMethod.GET})
    @ResponseBody
    public List<SurveySummary> loadSummariesByUser(@PathVariable int userId) {
        User user = (User)((UserManager)this.itemManager).loadById((Object)userId);
        return this.surveyManager.getSurveySummaries(user);
    }

    @Override
    protected List<User> loadAllItems() {
        User loggedUser = this.sessionManager.getSessionState().getUser();
        return ((UserManager)this.itemManager).loadAllAvailableUsers(loggedUser);
    }

    @Override
    protected User getLoggedUser() {
        return this.sessionManager.getLoggedUser();
    }

    @Override
    @Transactional
    @RequestMapping(method={RequestMethod.DELETE})
    @ResponseBody
    public Response delete(@Valid UsersDeleteParameters parameters) {
        for (int userId : parameters.getUserIds()) {
            ((UserManager)this.itemManager).deleteById((Object)userId);
        }
        return new Response();
    }

    @RequestMapping(value={"validatepasswordchange"}, method={RequestMethod.POST})
    @ResponseBody
    public Response validatePasswordChangeParameters(@Valid PasswordChangeParameters params, BindingResult result) {
        return this.generateFormValidationResponse(result);
    }

    @Transactional
    @RequestMapping(value={"changepassword"}, method={RequestMethod.POST})
    @ResponseBody
    public Response changePassword(@Valid PasswordChangeParameters params, BindingResult bindingResult) throws Exception {
        String username = this.getLoggedUser().getUsername();
        ((UserManager)this.itemManager).changePassword(username, params.getOldPassword(), params.getNewPassword());
        return new Response();
    }

    @Override
    protected UserForm createFormInstance(User item) {
        return new UserForm(item);
    }

    @Override
    protected User createItemInstance() {
        return new User();
    }

    @Override
    protected void copyFormIntoItem(UserForm form, User item) {
        super.copyFormIntoItem(form, item);
        if (form.getRole() != null) {
            item.setRole(form.getRole());
        }
    }

    public static class PasswordChangeParameters {
        private String oldPassword;
        private String newPassword;
        private String retypedPassword;

        public String getOldPassword() {
            return this.oldPassword;
        }

        public void setOldPassword(String oldPassword) {
            this.oldPassword = oldPassword;
        }

        public String getNewPassword() {
            return this.newPassword;
        }

        public void setNewPassword(String newPassword) {
            this.newPassword = newPassword;
        }

        public String getRetypedPassword() {
            return this.retypedPassword;
        }

        public void setRetypedPassword(String retypedPassword) {
            this.retypedPassword = retypedPassword;
        }
    }

    public static class UserForm
    extends PersistedObjectForm<Integer, User> {
        private boolean enabled = true;
        private String username;
        private UserRole role;
        private List<UserRole> roles;
        private String rawPassword;
        private String retypedPassword;

        public UserForm() {
        }

        public UserForm(User user) {
            super((Object)user);
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public UserRole getRole() {
            return this.role;
        }

        public void setRole(UserRole role) {
            this.role = role;
        }

        public List<UserRole> getRoles() {
            return this.roles;
        }

        public void setRoles(List<UserRole> roles) {
            this.roles = roles;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getRawPassword() {
            return this.rawPassword;
        }

        public void setRawPassword(String rawPassword) {
            this.rawPassword = rawPassword;
        }

        public String getRetypedPassword() {
            return this.retypedPassword;
        }

        public void setRetypedPassword(String retypedPassword) {
            this.retypedPassword = retypedPassword;
        }
    }

    public static class UsersDeleteParameters {
        private int loggedUserId;
        private List<Integer> userIds;

        public int getLoggedUserId() {
            return this.loggedUserId;
        }

        public void setLoggedUserId(int loggedUserId) {
            this.loggedUserId = loggedUserId;
        }

        public List<Integer> getUserIds() {
            return this.userIds;
        }

        public void setUserIds(List<Integer> userIds) {
            this.userIds = userIds;
        }
    }
}

