/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.form.validator;

import org.openforis.collect.designer.form.validator.SurveyObjectFormValidator;
import org.openforis.collect.designer.viewmodel.SurveyObjectBaseVM;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.idm.metamodel.Unit;
import org.zkoss.bind.ValidationContext;
import org.zkoss.util.resource.Labels;

public class UnitFormValidator
extends SurveyObjectFormValidator<Unit> {
    protected static final String NAME_FIELD = "name";
    protected static final String DIMENSION_FIELD_NAME = "dimensionLabel";

    @Override
    protected void internalValidate(ValidationContext ctx) {
        this.validateName(ctx);
        this.validateRequired(ctx, DIMENSION_FIELD_NAME);
    }

    protected boolean validateName(ValidationContext ctx) {
        boolean result = this.validateRequired(ctx, NAME_FIELD);
        if (result && (result = this.validateInternalName(ctx, NAME_FIELD))) {
            result = this.validateNameUniqueness(ctx);
        }
        return result;
    }

    protected boolean validateNameUniqueness(ValidationContext ctx) {
        String name;
        SurveyObjectBaseVM viewModel = (SurveyObjectBaseVM)this.getVM(ctx);
        Unit editedItem = (Unit)viewModel.getEditedItem();
        CollectSurvey survey = viewModel.getSurvey();
        Unit existingItem = survey.getUnit(name = (String)this.getValue(ctx, NAME_FIELD));
        if (existingItem != null && existingItem.getId() != editedItem.getId()) {
            String message = Labels.getLabel((String)"global.item.validation.name_already_defined");
            this.addInvalidMessage(ctx, NAME_FIELD, message);
            return false;
        }
        return true;
    }
}

