/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.web.validator;

import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.openforis.collect.datacleansing.form.validation.SimpleValidator;
import org.openforis.collect.manager.UserManager;
import org.openforis.collect.model.User;
import org.openforis.collect.web.controller.UserController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;

@Component
public class UserValidator
extends SimpleValidator<UserController.UserForm> {
    private static final String USERNAME_FIELD = "username";
    private static final Pattern USERNAME_PATTERN = Pattern.compile("^[a-z][a-z0-9_\\-\\.]{3,14}$");
    private static final String ROLE_FIELD = "role";
    private static final String RAW_PASSWORD_FIELD = "rawPassword";
    private static final String RETYPED_PASSWORD_FIELD = "retypedPassword";
    private static final String INVALID_USERNAME_MESSAGE_KEY = "user.validation.invalid_username";
    private static final String PASSWORD_PATTERN_MESSAGE_KEY = "user.validation.wrong_password_pattern";
    protected static final String WRONG_RETYPED_PASSWORD_MESSAGE_KEY = "user.validation.wrong_retyped_password";
    @Autowired
    private UserManager userManager;

    @Override
    public void validate(Object target, Errors errors) {
        super.validate(target, errors);
        if (target instanceof UserController.UsersDeleteParameters) {
            // empty if block
        }
    }

    @Override
    public void validateForm(UserController.UserForm target, Errors errors) {
        String rawPassword = (String)errors.getFieldValue(RAW_PASSWORD_FIELD);
        String retypedPassword = (String)errors.getFieldValue(RETYPED_PASSWORD_FIELD);
        if (this.validateRequiredFields(errors, USERNAME_FIELD)) {
            if (target.getId() == null) {
                if (this.validateRegEx(errors, USERNAME_FIELD, USERNAME_PATTERN, INVALID_USERNAME_MESSAGE_KEY)) {
                    this.validateUniqueness(target, errors);
                }
                this.validateRequiredField(errors, RAW_PASSWORD_FIELD);
            }
            if (StringUtils.isNotBlank((CharSequence)rawPassword)) {
                UserValidator.validatePassword(errors, rawPassword, RAW_PASSWORD_FIELD);
            }
        }
        this.validateRequiredField(errors, ROLE_FIELD);
        if (!StringUtils.equals((CharSequence)rawPassword, (CharSequence)retypedPassword)) {
            errors.rejectValue(RETYPED_PASSWORD_FIELD, WRONG_RETYPED_PASSWORD_MESSAGE_KEY);
        }
    }

    protected static boolean validatePassword(Errors errors, String password, String passwordField) {
        if (Pattern.matches("^[a-zA-Z]\\w{3,14}$", password)) {
            return true;
        }
        errors.rejectValue(passwordField, PASSWORD_PATTERN_MESSAGE_KEY);
        return false;
    }

    private boolean validateUniqueness(UserController.UserForm target, Errors errors) {
        User oldUser = this.userManager.loadByUserName(target.getUsername());
        if (!(oldUser == null || target.getId() != null && oldUser.getId().equals(target.getId()))) {
            this.rejectDuplicateValue(errors, USERNAME_FIELD, new Object[0]);
            return false;
        }
        return true;
    }

    @Override
    public boolean supports(Class<?> clazz) {
        boolean result = super.supports(clazz);
        return result || UserController.UsersDeleteParameters.class.isAssignableFrom(clazz);
    }
}

