/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.form.validator;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openforis.collect.designer.form.validator.FormValidator;
import org.openforis.collect.designer.viewmodel.CheckVM;
import org.openforis.idm.metamodel.NodeDefinition;
import org.openforis.idm.metamodel.expression.ExpressionValidator;
import org.openforis.idm.metamodel.validation.Check;
import org.zkoss.bind.ValidationContext;

public abstract class CheckFormValidator
extends FormValidator {
    private static final String PARENT_DEFINITION_ARG = "parentDefinition";
    protected static final String CONDITION_FIELD = "condition";
    protected static final String MESSAGE_FIELD = "message";

    @Override
    protected void internalValidate(ValidationContext ctx) {
        NodeDefinition nodeDef = this.getContextNode(ctx);
        this.validateBooleanExpressionField(ctx, nodeDef, CONDITION_FIELD);
        this.validateNestedExpressionsInMessage(ctx);
    }

    protected NodeDefinition getContextNode(ValidationContext ctx) {
        NodeDefinition result = (NodeDefinition)ctx.getValidatorArg(PARENT_DEFINITION_ARG);
        return result;
    }

    protected Check<?> getEditedCheck(ValidationContext ctx) {
        CheckVM vm = (CheckVM)this.getVM(ctx);
        Check check = (Check)vm.getEditedItem();
        return check;
    }

    private boolean validateNestedExpressionsInMessage(ValidationContext ctx) {
        NodeDefinition nodeDef = this.getContextNode(ctx);
        String message = (String)this.getValue(ctx, MESSAGE_FIELD, true);
        if (StringUtils.isBlank((CharSequence)message)) {
            return true;
        }
        Check<?> check = this.getEditedCheck(ctx);
        List expressions = check.extractExpressionsFromMessage(message);
        for (String expr : expressions) {
            boolean result = this.validateExpression(ctx, ExpressionValidator.ExpressionType.VALUE, MESSAGE_FIELD, (NodeDefinition)nodeDef.getParentEntityDefinition(), nodeDef, expr);
            if (result) continue;
            return false;
        }
        return true;
    }
}

