/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.web.validator;

import org.apache.commons.lang3.StringUtils;
import org.openforis.collect.datacleansing.form.validation.SimpleValidator;
import org.openforis.collect.manager.UserManager;
import org.openforis.collect.model.User;
import org.openforis.collect.web.controller.UserController;
import org.openforis.collect.web.validator.UserValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;

@Component
@Scope(value="session")
public class PasswordChangeValidator
extends SimpleValidator<UserController.PasswordChangeParameters> {
    private static final String WRONG_PASSWORD_SPECIFIED_MESSAGE_KEY = "user.validation.wrongPasswordSpecified";
    private static final String OLD_PASSWORD_FIELD = "oldPassword";
    private static final String NEW_PASSWORD_FIELD = "newPassword";
    private static final String RETYPED_PASSWORD_FIELD = "retypedPassword";
    @Autowired
    private UserManager userManager;

    @Override
    public void validateForm(UserController.PasswordChangeParameters target, Errors errors) {
        this.validateOldPassword(errors);
        this.validateNewPassword(errors);
        this.validateRetypedPassword(errors);
    }

    private void validateOldPassword(Errors errors) {
        if (this.validateRequiredField(errors, OLD_PASSWORD_FIELD)) {
            String oldPassword = (String)errors.getFieldValue(OLD_PASSWORD_FIELD);
            User loggedUser = this.sessionManager.getLoggedUser();
            if (!this.userManager.verifyPassword(loggedUser.getUsername(), oldPassword)) {
                errors.rejectValue(OLD_PASSWORD_FIELD, WRONG_PASSWORD_SPECIFIED_MESSAGE_KEY);
            }
        }
    }

    private void validateNewPassword(Errors errors) {
        if (this.validateRequiredField(errors, NEW_PASSWORD_FIELD)) {
            String newPassword = (String)errors.getFieldValue(NEW_PASSWORD_FIELD);
            UserValidator.validatePassword(errors, newPassword, NEW_PASSWORD_FIELD);
        }
    }

    private void validateRetypedPassword(Errors errors) {
        String retypedPassword;
        String newPassword;
        if (this.validateRequiredField(errors, RETYPED_PASSWORD_FIELD) && !StringUtils.equals((CharSequence)(newPassword = (String)errors.getFieldValue(NEW_PASSWORD_FIELD)), (CharSequence)(retypedPassword = (String)errors.getFieldValue(RETYPED_PASSWORD_FIELD)))) {
            errors.rejectValue(RETYPED_PASSWORD_FIELD, "user.validation.wrong_retyped_password");
        }
    }
}

