/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.form.validator;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.openforis.collect.designer.form.validator.BaseValidator;
import org.openforis.collect.designer.viewmodel.SurveyBaseVM;
import org.openforis.collect.designer.viewmodel.SurveyObjectBaseVM;
import org.openforis.commons.lang.Strings;
import org.openforis.idm.metamodel.NodeDefinition;
import org.openforis.idm.metamodel.expression.ExpressionValidator;
import org.zkoss.bind.ValidationContext;
import org.zkoss.bind.impl.BinderImpl;
import org.zkoss.bind.sys.ValidationMessages;
import org.zkoss.util.resource.Labels;

public abstract class FormValidator
extends BaseValidator {
    protected static final String INVALID_EXPRESSION_MESSAGE_KEY = "survey.validation.error.invalid_expression";
    protected static final String CIRCULAR_REFERENCE_IN_EXPRESSION_MESSAGE_KEY = "survey.validation.error.circular_reference";
    protected static final String RESERVED_NAME_MESSAGE_KEY = "survey.validation.error.reserved_name";
    protected boolean blocking;

    public void validate(ValidationContext ctx) {
        if (this.isEditingItem(ctx)) {
            this.internalValidate(ctx);
            this.afterValidate(ctx);
        }
    }

    protected void afterValidate(ValidationContext ctx) {
        Object vm = this.getVM(ctx);
        if (vm instanceof SurveyBaseVM) {
            Map<String, List<String>> validationMessagesByField = this.getValidationMessagesByField(ctx);
            ((SurveyBaseVM)vm).dispatchCurrentFormValidatedCommand(ctx.isValid(), this.blocking, validationMessagesByField);
        }
    }

    private Map<String, List<String>> getValidationMessagesByField(ValidationContext ctx) {
        LinkedHashMap<String, List<String>> validationMessagesByField = new LinkedHashMap<String, List<String>>();
        Set<String> fieldNames = this.getFieldNames(ctx);
        ValidationMessages validationMessages = ((BinderImpl)ctx.getBindContext().getBinder()).getValidationMessages();
        if (validationMessages != null && validationMessages.getMessages() != null && validationMessages.getMessages().length > 0) {
            for (String fieldName : fieldNames) {
                String[] notEmptyMessages;
                String[] keyMessages = validationMessages.getKeyMessages(fieldName);
                if (keyMessages == null || (notEmptyMessages = Strings.filterNotBlank((String[])keyMessages)).length <= 0) continue;
                validationMessagesByField.put(fieldName, Arrays.asList(notEmptyMessages));
            }
        }
        return validationMessagesByField;
    }

    protected abstract void internalValidate(ValidationContext var1);

    protected Set<String> getFieldNames(ValidationContext ctx) {
        HashSet<String> result = new HashSet<String>();
        result.addAll(this.getProperties(ctx).keySet());
        return result;
    }

    protected ExpressionValidator getExpressionValidator(ValidationContext ctx) {
        Object vm = this.getVM(ctx);
        if (vm instanceof SurveyBaseVM) {
            ExpressionValidator result = ((SurveyBaseVM)vm).getExpressionValidator();
            return result;
        }
        return null;
    }

    protected boolean validateBooleanExpressionField(ValidationContext ctx, NodeDefinition contextNode, String field) {
        return this.validateExpressionField(ctx, ExpressionValidator.ExpressionType.BOOLEAN, field, contextNode);
    }

    protected boolean validateExpressionField(ValidationContext ctx, ExpressionValidator.ExpressionType type, String field, NodeDefinition contextNode) {
        return this.validateExpressionField(ctx, type, field, contextNode.getParentDefinition(), contextNode);
    }

    protected boolean validateExpressionField(ValidationContext ctx, ExpressionValidator.ExpressionType type, String field, NodeDefinition contextNodeDef, NodeDefinition thisNodeDef) {
        if (contextNodeDef == null) {
            return true;
        }
        String epression = (String)this.getValue(ctx, field);
        return this.validateExpression(ctx, type, field, contextNodeDef, thisNodeDef, epression);
    }

    protected boolean validateExpression(ValidationContext ctx, ExpressionValidator.ExpressionType type, String field, NodeDefinition contextNodeDef, NodeDefinition thisNodeDef, String epression) {
        if (StringUtils.isBlank((CharSequence)epression)) {
            return true;
        }
        ExpressionValidator expressionValidator = this.getExpressionValidator(ctx);
        ExpressionValidator.ExpressionValidationResult result = expressionValidator.validateExpression(type, contextNodeDef, thisNodeDef, epression);
        if (result.isError()) {
            this.addInvalidMessage(ctx, field, this.generateErrorMessageLabel(result, INVALID_EXPRESSION_MESSAGE_KEY));
            return false;
        }
        ExpressionValidator.ExpressionValidationResult circularReferenceValidationResult = expressionValidator.validateCircularReferenceAbsence(contextNodeDef, thisNodeDef, epression);
        if (circularReferenceValidationResult.isError()) {
            this.addInvalidMessage(ctx, field, this.generateErrorMessageLabel(circularReferenceValidationResult, CIRCULAR_REFERENCE_IN_EXPRESSION_MESSAGE_KEY));
            return false;
        }
        return true;
    }

    protected boolean validateValueExpressionField(ValidationContext ctx, NodeDefinition contextDefn, String field) {
        NodeDefinition parentDefn = contextDefn.getParentDefinition();
        return this.validateValueExpressionField(ctx, contextDefn, parentDefn, field);
    }

    protected boolean validateValueExpressionField(ValidationContext ctx, NodeDefinition contextDefn, NodeDefinition parentEntityDefn, String field) {
        return this.validateExpressionField(ctx, ExpressionValidator.ExpressionType.VALUE, field, parentEntityDefn, contextDefn);
    }

    protected boolean validatePathExpressionField(ValidationContext ctx, NodeDefinition contextNode, String fieldName) {
        return this.validateExpressionField(ctx, ExpressionValidator.ExpressionType.SCHEMA_PATH, fieldName, contextNode);
    }

    protected boolean validateNameNotReserved(ValidationContext ctx, String nameField, String[] reservedNames) {
        String name = (String)this.getValue(ctx, nameField);
        if (ArrayUtils.contains((Object[])reservedNames, (Object)name)) {
            String message = Labels.getLabel((String)RESERVED_NAME_MESSAGE_KEY);
            this.addInvalidMessage(ctx, nameField, message);
            return false;
        }
        return true;
    }

    public boolean isBlocking() {
        return this.blocking;
    }

    protected boolean isEditingItem(ValidationContext ctx) {
        Object vm = this.getVM(ctx);
        if (vm instanceof SurveyObjectBaseVM) {
            return ((SurveyObjectBaseVM)vm).isEditingItem();
        }
        return false;
    }

    private String generateErrorMessageLabel(ExpressionValidator.ExpressionValidationResult result, String messageKey) {
        String message = (String)StringUtils.defaultIfBlank((CharSequence)result.getDetailedMessage(), (CharSequence)result.getMessage());
        String messageLabel = FormValidator.getMessage(messageKey, message);
        return messageLabel;
    }

    protected static String getMessage(String messageKey, String ... messageArgs) {
        Object[] normalizedArguments = FormValidator.normalizeMessageArguments(messageArgs);
        return Labels.getLabel((String)messageKey, (Object[])normalizedArguments);
    }

    protected static String[] normalizeMessageArguments(String ... messages) {
        String[] result = new String[messages.length];
        for (int i = 0; i < messages.length; ++i) {
            result[i] = FormValidator.normalizeMessageArgument(messages[i]);
        }
        return result;
    }

    protected static String normalizeMessageArgument(String message) {
        return Strings.textToHtml((String)message);
    }
}

