/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.form.validator;

import org.openforis.collect.designer.form.validator.FormValidator;
import org.openforis.collect.designer.viewmodel.SurveyObjectBaseVM;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.idm.geospatial.CoordinateOperations;
import org.openforis.idm.metamodel.SpatialReferenceSystem;
import org.openforis.idm.metamodel.SurveyContext;
import org.zkoss.bind.ValidationContext;
import org.zkoss.util.resource.Labels;

public class SRSFormValidator
extends FormValidator {
    protected static final String ID_FIELD = "id";
    protected static final String WKT_FIELD = "wellKnownText";
    private static final String ITEM_ID_ALREADY_DEFINED_MESSAGE_KEY = "survey.srs.validation.id_already_defined";

    @Override
    protected void internalValidate(ValidationContext ctx) {
        this.validateId(ctx);
    }

    protected boolean validateId(ValidationContext ctx) {
        boolean result = this.validateRequired(ctx, ID_FIELD);
        if (result) {
            result = this.validateIdUniqueness(ctx);
        }
        result = this.validateRequired(ctx, WKT_FIELD) ? result && this.validateWKT(ctx) : false;
        return result;
    }

    protected boolean validateIdUniqueness(ValidationContext ctx) {
        String id;
        SurveyObjectBaseVM viewModel = (SurveyObjectBaseVM)this.getVM(ctx);
        SpatialReferenceSystem editedItem = (SpatialReferenceSystem)viewModel.getEditedItem();
        CollectSurvey survey = viewModel.getSurvey();
        SpatialReferenceSystem existingItem = survey.getSpatialReferenceSystem(id = (String)this.getValue(ctx, ID_FIELD));
        if (existingItem != null && !existingItem.equals((Object)editedItem)) {
            String message = Labels.getLabel((String)ITEM_ID_ALREADY_DEFINED_MESSAGE_KEY);
            this.addInvalidMessage(ctx, ID_FIELD, message);
            return false;
        }
        return true;
    }

    private boolean validateWKT(ValidationContext ctx) {
        String wkt = (String)this.getValue(ctx, WKT_FIELD);
        CollectSurvey survey = this.getSurvey(ctx);
        SurveyContext context = survey.getContext();
        CoordinateOperations coordinateOperations = context.getCoordinateOperations();
        try {
            coordinateOperations.validateWKT(wkt);
            return true;
        }
        catch (Exception e) {
            String message = Labels.getLabel((String)"survey.srs.validation.error.invalid_wkt", (Object[])new String[]{e.getMessage()});
            this.addInvalidMessage(ctx, WKT_FIELD, message);
            return false;
        }
    }

    private CollectSurvey getSurvey(ValidationContext ctx) {
        SurveyObjectBaseVM viewModel = (SurveyObjectBaseVM)this.getVM(ctx);
        CollectSurvey survey = viewModel.getSurvey();
        return survey;
    }
}

