/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.viewmodel;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.openforis.collect.concurrency.CollectJobManager;
import org.openforis.collect.designer.model.LabelledItem;
import org.openforis.collect.designer.session.SessionStatus;
import org.openforis.collect.designer.util.ComponentUtil;
import org.openforis.collect.designer.util.PopUpUtil;
import org.openforis.collect.io.metadata.collectearth.CollectEarthProjectFileCreator;
import org.openforis.collect.manager.UserGroupManager;
import org.openforis.collect.manager.UserManager;
import org.openforis.collect.model.User;
import org.openforis.collect.model.UserGroup;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.zkoss.bind.BindUtils;
import org.zkoss.bind.Binder;
import org.zkoss.bind.SimpleForm;
import org.zkoss.util.resource.Labels;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.Sessions;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.select.annotation.VariableResolver;
import org.zkoss.zk.ui.select.annotation.WireVariable;
import org.zkoss.zkplus.spring.DelegatingVariableResolver;
import org.zkoss.zul.ListModelList;
import org.zkoss.zul.Window;

@VariableResolver(value={DelegatingVariableResolver.class})
public abstract class BaseVM {
    private static final String PUBLIC_USER_GROUP_LABEL_KEY = "survey.template.usergroup.public";
    private static final String PRIVATE_USER_GROUP_LABEL_KEY = "survey.template.usergroup.private";
    private static final SimpleDateFormat PRETTY_DATE_FORMAT = new SimpleDateFormat("dd/MM/yyyy HH:mm");
    protected static final ServiceLoader<CollectEarthProjectFileCreator> COLLECT_EARTH_PROJECT_FILE_CREATOR_LOADER = ServiceLoader.load(CollectEarthProjectFileCreator.class);
    @WireVariable
    protected UserManager userManager;
    @WireVariable
    protected CollectJobManager jobManager;
    @WireVariable
    protected UserGroupManager userGroupManager;
    private ListModelList<LabelledItem> userGroupsModel;

    void init() {
        this.initUserGroupsModel();
    }

    protected void initUserGroupsModel() {
        ArrayList<LabelledItem> items = new ArrayList<LabelledItem>();
        User loggedUser = this.getLoggedUser();
        List userGroups = this.userGroupManager.findAllRelatedUserGroups(loggedUser);
        for (UserGroup userGroup : userGroups) {
            String label = userGroup.getName().equals("default_public_group") ? Labels.getLabel((String)PUBLIC_USER_GROUP_LABEL_KEY) : (userGroup.getName().equals(this.userGroupManager.getDefaultPrivateUserGroupName(loggedUser)) ? Labels.getLabel((String)PRIVATE_USER_GROUP_LABEL_KEY) : userGroup.getLabel());
            items.add(new LabelledItem(userGroup.getName(), label));
        }
        this.userGroupsModel = new ListModelList(items);
        this.userGroupsModel.setMultiple(false);
    }

    protected LabelledItem getDefaultPublicUserGroupItem() {
        return (LabelledItem)this.userGroupsModel.getElementAt(0);
    }

    public String getComponentsPath() {
        return "/zk/surveydesigner/";
    }

    protected SessionStatus getSessionStatus() {
        String key;
        Session session = this.getSession();
        SessionStatus sessionStatus = (SessionStatus)session.getAttribute(key = "designer_status");
        if (sessionStatus == null) {
            sessionStatus = new SessionStatus();
            session.setAttribute(key, (Object)sessionStatus);
        }
        return sessionStatus;
    }

    public String getCurrentLanguageCode() {
        SessionStatus sessionStatus = this.getSessionStatus();
        return sessionStatus.getCurrentLanguageCode();
    }

    protected Session getSession() {
        Session session = Executions.getCurrent().getSession();
        return session;
    }

    public User getLoggedUser() {
        String loggedUsername = this.getLoggedUsername();
        User user = this.userManager.loadByUserName(loggedUsername);
        return user;
    }

    public String getLoggedUsername() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return authentication.getName();
    }

    protected static Window openPopUp(String url, boolean modal) {
        return BaseVM.openPopUp(url, modal, null);
    }

    protected static Window openPopUp(String url, boolean modal, Map<?, ?> args) {
        return PopUpUtil.openPopUp(url, modal, args);
    }

    protected static void closePopUp(Window popUp) {
        PopUpUtil.closePopUp(popUp);
    }

    protected void notifyChange(String ... properties) {
        for (String property : properties) {
            BindUtils.postNotifyChange(null, null, (Object)this, (String)property);
        }
    }

    protected String getInitParameter(String name) {
        WebApp webApp = Sessions.getCurrent().getWebApp();
        return webApp.getInitParameter(name);
    }

    protected <T> T getFormFieldValue(Binder binder, String field) {
        Object form = ComponentUtil.getForm(binder);
        return this.getFormFieldValue(form, field);
    }

    protected <T> T getFormFieldValue(Object form, String field) {
        if (form instanceof SimpleForm) {
            return (T)((SimpleForm)form).getField(field);
        }
        try {
            return (T)PropertyUtils.getProperty((Object)form, (String)field);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected void setFormFieldValue(Binder binder, String field, Object value) {
        this.setFormFieldValue(ComponentUtil.getForm(binder), field, value);
    }

    protected void setFormFieldValue(Object form, String field, Object value) {
        if (form instanceof SimpleForm) {
            ((SimpleForm)form).setField(field, value);
        } else {
            try {
                PropertyUtils.setProperty((Object)form, (String)field, (Object)value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        BindUtils.postNotifyChange(null, null, (Object)form, (String)field);
    }

    public String joinValues(String[] values, String separator) {
        return this.joinList(Arrays.asList(values), separator);
    }

    public String joinList(List<String> values, String separator) {
        return StringUtils.join(values, (String)separator);
    }

    public String prettyDateFormat(Date date) {
        return PRETTY_DATE_FORMAT.format(date);
    }

    public ListModelList<LabelledItem> getUserGroupsModel() {
        return this.userGroupsModel;
    }
}

