/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.viewmodel.referencedata;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.openforis.collect.designer.util.MessageUtil;
import org.openforis.collect.designer.util.PopUpUtil;
import org.openforis.collect.designer.util.Resources;
import org.openforis.collect.designer.viewmodel.BaseVM;
import org.openforis.collect.io.metadata.parsing.ParsingError;
import org.openforis.commons.io.excel.ExcelFlatValuesWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.bind.annotation.Command;
import org.zkoss.bind.annotation.ExecutionArgParam;
import org.zkoss.bind.annotation.Init;
import org.zkoss.util.resource.Labels;
import org.zkoss.zul.Filedownload;
import org.zkoss.zul.ListModelList;
import org.zkoss.zul.Window;

public class ReferenceDataImportErrorsPopUpVM
extends BaseVM {
    private static final Logger logger = LoggerFactory.getLogger(ReferenceDataImportErrorsPopUpVM.class);
    private static final String ERRORS_PARAM = "errors";
    private static final String TITLE_PARAM = "title";
    private static final String MESSAGE_KEY_DUPLICATE_VALUE = "survey.reference_data.import_error.type.duplicate_value.message";
    private List<ParsingError> errors;
    private String title;

    public static Window showPopUp(List<ParsingError> errors, String title) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put(ERRORS_PARAM, errors);
        args.put(TITLE_PARAM, title);
        return PopUpUtil.openPopUp(Resources.Component.REFERENCE_DATA_IMPORT_ERRORS_POPUP.getLocation(), true, args);
    }

    @Init
    public void init(@ExecutionArgParam(value="errors") List<ParsingError> errors, @ExecutionArgParam(value="title") String title) {
        this.errors = errors;
        this.title = title;
    }

    @Command
    public void exportErrorsToExcel() {
        try {
            File outputFile = File.createTempFile("collect_reference_data_import_errors", ".xlsx");
            FileOutputStream out = new FileOutputStream(outputFile);
            ExcelFlatValuesWriter csvWriter = new ExcelFlatValuesWriter((OutputStream)out);
            csvWriter.writeHeaders(Arrays.asList("row", "columns", "type", "message"));
            for (ParsingError error : this.errors) {
                csvWriter.writeNext(Arrays.asList(String.valueOf(error.getRow()), error.getColumnsString(), this.getErrorTypeLabel(error), this.getErrorMessageLabel(error)));
            }
            csvWriter.close();
            String fileName = "data_import_errors.xlsx";
            String contentType = URLConnection.guessContentTypeFromName(fileName);
            FileInputStream is = new FileInputStream(outputFile);
            Filedownload.save((InputStream)is, (String)contentType, (String)fileName);
        }
        catch (Exception e) {
            logger.error("Error exporting list of errors", (Throwable)e);
            MessageUtil.showError("survey.schema.export_summary.error", e.getMessage());
        }
    }

    public List<ParsingError> getErrors() {
        return new ListModelList(this.errors);
    }

    public String getTitle() {
        return this.title;
    }

    public String getErrorTypeLabel(ParsingError error) {
        return Labels.getLabel((String)String.format("survey.reference_data.import_error.type.%s", error.getErrorType().name().toLowerCase(Locale.ENGLISH)));
    }

    public String getErrorMessageLabel(ParsingError error) {
        String label = Labels.getLabel((String)error.getMessage(), (Object[])error.getMessageArgs());
        if (label == null && error.getErrorType() == ParsingError.ErrorType.DUPLICATE_VALUE) {
            label = Labels.getLabel((String)MESSAGE_KEY_DUPLICATE_VALUE, (Object[])error.getMessageArgs());
        }
        return label == null ? error.getMessage() : label;
    }
}

