/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.datacleansing;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.openforis.collect.datacleansing.DataCleansingItem;
import org.openforis.collect.datacleansing.DataCleansingStepValue;
import org.openforis.collect.datacleansing.DataQuery;
import org.openforis.collect.model.CollectSurvey;

public class DataCleansingStep
extends DataCleansingItem {
    private static final long serialVersionUID = 1L;
    private String title;
    private String description;
    private Integer queryId;
    private DataCleansingStepType type = DataCleansingStepType.ATTRIBUTE_UPDATE;
    private List<DataCleansingStepValue> updateValues = new ArrayList<DataCleansingStepValue>();
    private transient DataQuery query;

    public DataCleansingStep(CollectSurvey survey) {
        super(survey);
    }

    public DataCleansingStep(CollectSurvey survey, UUID uuid) {
        super(survey, uuid);
    }

    public void addUpdateValue(DataCleansingStepValue updateValue) {
        if (this.updateValues == null) {
            this.updateValues = new ArrayList<DataCleansingStepValue>();
        }
        this.updateValues.add(updateValue);
    }

    public Integer getQueryId() {
        return this.query == null ? this.queryId : (Integer)this.query.getId();
    }

    public void setQuery(DataQuery query) {
        this.query = query;
        this.queryId = query == null ? null : (Integer)query.getId();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setQueryId(Integer queryId) {
        this.queryId = queryId;
        this.query = null;
    }

    public DataCleansingStepType getType() {
        return this.type;
    }

    public void setType(DataCleansingStepType type) {
        this.type = type;
    }

    public DataQuery getQuery() {
        return this.query;
    }

    public List<DataCleansingStepValue> getUpdateValues() {
        return this.updateValues;
    }

    public void setUpdateValues(List<DataCleansingStepValue> values) {
        this.updateValues = values;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.getId() != null) {
            sb.append('[');
            sb.append(this.getId());
            sb.append(']');
        }
        if (this.title != null) {
            sb.append(this.title);
        }
        return sb.toString();
    }

    public boolean deepEquals(Object obj, boolean ignoreId) {
        if (this == obj) {
            return true;
        }
        if (!super.deepEquals(obj, ignoreId)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        DataCleansingStep other = (DataCleansingStep)((Object)obj);
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.query == null ? other.query != null : !this.query.deepEquals((Object)other.query, ignoreId)) {
            return false;
        }
        if (!ignoreId && (this.queryId == null ? other.queryId != null : !this.queryId.equals(other.queryId))) {
            return false;
        }
        return !(this.title == null ? other.title != null : !this.title.equals(other.title));
    }

    public static enum DataCleansingStepType {
        ATTRIBUTE_UPDATE('a'),
        ENTITY_DELETE('e'),
        RECORD_DELETE('r');

        private char code;

        private DataCleansingStepType(char code) {
            this.code = code;
        }

        public char getCode() {
            return this.code;
        }

        public static DataCleansingStepType fromCode(char typeCode) {
            for (DataCleansingStepType type : DataCleansingStepType.values()) {
                if (type.code != typeCode) continue;
                return type;
            }
            throw new IllegalArgumentException("Invlaid DataCleansingStepType code: " + typeCode);
        }
    }
}

