/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.form.validator;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openforis.collect.designer.form.validator.NodeDefinitionFormValidator;
import org.openforis.collect.metamodel.ui.UIOptions;
import org.openforis.collect.metamodel.ui.UITab;
import org.openforis.collect.metamodel.ui.UITabSet;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.idm.metamodel.EntityDefinition;
import org.openforis.idm.metamodel.NodeDefinition;
import org.openforis.idm.metamodel.expression.ExpressionValidator;
import org.zkoss.bind.ValidationContext;
import org.zkoss.util.resource.Labels;

public class EntityDefinitionFormValidator
extends NodeDefinitionFormValidator {
    private static final String VIRTUAL_FIELD = "virtual";
    private static final String GENERATOR_EXPRESSION_FIELD = "generatorExpression";
    protected static final String LAYOUT_FIELD = "layoutType";

    @Override
    protected void internalValidate(ValidationContext ctx) {
        super.internalValidate(ctx);
        Object virtual = this.getValue(ctx, VIRTUAL_FIELD);
        if (Boolean.TRUE.equals(virtual) && this.validateRequired(ctx, GENERATOR_EXPRESSION_FIELD)) {
            this.validateExpressionField(ctx, ExpressionValidator.ExpressionType.SCHEMA_PATH, GENERATOR_EXPRESSION_FIELD, this.getEditedNode(ctx));
        }
        this.validateLayout(ctx);
    }

    protected void validateLayout(ValidationContext ctx) {
        boolean valid;
        EntityDefinition editedNode = (EntityDefinition)this.getEditedNode(ctx);
        if (editedNode.isVirtual()) {
            return;
        }
        String field = LAYOUT_FIELD;
        String layoutValue = this.getValueWithDefault(ctx, field, UIOptions.Layout.FORM.name());
        UIOptions.Layout layout = UIOptions.Layout.valueOf((String)layoutValue);
        EntityDefinition parentEntity = this.getParentEntity(ctx);
        CollectSurvey survey = (CollectSurvey)editedNode.getSurvey();
        UIOptions uiOptions = survey.getUIOptions();
        Boolean multiple = (Boolean)this.getValue(ctx, "multiple");
        UITab tab = uiOptions.getAssignedTab((NodeDefinition)editedNode);
        if (tab != null && !(valid = uiOptions.isLayoutSupported(parentEntity, editedNode.getId(), tab, multiple.booleanValue(), layout))) {
            String message = Labels.getLabel((String)"survey.schema.entity.layout.not_supported_error");
            this.addInvalidMessage(ctx, field, message);
        }
    }

    protected UITab getAssociatedTab(ValidationContext ctx, UIOptions uiOptions, EntityDefinition parentEntity) {
        String tabName = (String)this.getValue(ctx, "tabName");
        if (parentEntity == null) {
            NodeDefinition editedNode = this.getEditedNode(ctx);
            UITabSet rootTabSet = uiOptions.getAssignedRootTabSet((EntityDefinition)editedNode);
            if (rootTabSet != null) {
                return uiOptions.getMainTab(rootTabSet);
            }
            return null;
        }
        if (StringUtils.isNotBlank((CharSequence)tabName)) {
            List assignableTabs = uiOptions.getTabsAssignableToChildren(parentEntity);
            for (UITab tab : assignableTabs) {
                if (!tab.getName().equals(tabName)) continue;
                return tab;
            }
        }
        return uiOptions.getAssignedTab((NodeDefinition)parentEntity);
    }
}

