/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.web.controller;

import jakarta.validation.Valid;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Sets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.openforis.collect.ProxyContext;
import org.openforis.collect.concurrency.CollectJobManager;
import org.openforis.collect.concurrency.SurveyLockingJob;
import org.openforis.collect.event.EventListener;
import org.openforis.collect.event.EventListenerToList;
import org.openforis.collect.event.EventProducer;
import org.openforis.collect.event.EventQueue;
import org.openforis.collect.event.RecordDeletedEvent;
import org.openforis.collect.event.RecordStep;
import org.openforis.collect.event.RecordTransaction;
import org.openforis.collect.io.SurveyBackupJob;
import org.openforis.collect.io.data.BulkRecordMoveJob;
import org.openforis.collect.io.data.CSVDataExportJob;
import org.openforis.collect.io.data.CSVDataImportJob;
import org.openforis.collect.io.data.DataImportSummary;
import org.openforis.collect.io.data.DataRestoreJob;
import org.openforis.collect.io.data.DataRestoreSummaryJob;
import org.openforis.collect.io.data.RecordProvider;
import org.openforis.collect.io.data.RecordProviderConfiguration;
import org.openforis.collect.io.data.TransactionalCSVDataImportJob;
import org.openforis.collect.io.data.TransactionalDataRestoreJob;
import org.openforis.collect.io.data.XMLParsingRecordProvider;
import org.openforis.collect.io.data.csv.CSVDataExportParameters;
import org.openforis.collect.io.data.csv.CSVDataExportParametersBase;
import org.openforis.collect.io.data.csv.CSVDataImportSettings;
import org.openforis.collect.io.data.proxy.DataImportStatusProxy;
import org.openforis.collect.manager.MessageSource;
import org.openforis.collect.manager.RandomRecordGenerator;
import org.openforis.collect.manager.RecordAccessControlManager;
import org.openforis.collect.manager.RecordFileManager;
import org.openforis.collect.manager.RecordGenerator;
import org.openforis.collect.manager.RecordManager;
import org.openforis.collect.manager.RecordPromoteException;
import org.openforis.collect.manager.RecordSessionManager;
import org.openforis.collect.manager.SurveyManager;
import org.openforis.collect.manager.UserGroupManager;
import org.openforis.collect.manager.UserManager;
import org.openforis.collect.manager.ValidationReportJob;
import org.openforis.collect.model.CollectRecord;
import org.openforis.collect.model.CollectRecordSummary;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.model.CollectSurveyContext;
import org.openforis.collect.model.RecordFilter;
import org.openforis.collect.model.RecordSummarySortField;
import org.openforis.collect.model.User;
import org.openforis.collect.model.UserGroup;
import org.openforis.collect.model.UserInGroup;
import org.openforis.collect.model.UserRole;
import org.openforis.collect.model.proxy.BasicUserProxy;
import org.openforis.collect.model.proxy.RecordProxy;
import org.openforis.collect.model.proxy.RecordSummaryProxy;
import org.openforis.collect.persistence.MissingRecordKeyException;
import org.openforis.collect.persistence.MultipleEditException;
import org.openforis.collect.persistence.RecordLockedException;
import org.openforis.collect.persistence.RecordPersistenceException;
import org.openforis.collect.remoting.service.dataimport.DataImportSummaryProxy;
import org.openforis.collect.utils.Controllers;
import org.openforis.collect.utils.Dates;
import org.openforis.collect.utils.Files;
import org.openforis.collect.utils.Proxies;
import org.openforis.collect.web.controller.BasicController;
import org.openforis.collect.web.controller.CollectJobController;
import org.openforis.collect.web.controller.RecordStatsGenerator;
import org.openforis.collect.web.manager.SessionRecordProvider;
import org.openforis.collect.web.session.SessionState;
import org.openforis.collect.web.ws.AppWS;
import org.openforis.commons.web.HttpResponses;
import org.openforis.commons.web.Response;
import org.openforis.concurrency.Job;
import org.openforis.concurrency.proxy.JobProxy;
import org.openforis.idm.metamodel.EntityDefinition;
import org.openforis.idm.metamodel.Schema;
import org.openforis.idm.metamodel.SurveyContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@Scope(value="session")
@RequestMapping(value={"api"})
public class RecordController
extends BasicController
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private RecordManager recordManager;
    @Autowired
    private RecordFileManager recordFileManager;
    @Autowired
    private SurveyManager surveyManager;
    @Autowired
    private CollectSurveyContext surveyContext;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private RandomRecordGenerator randomRecordGenerator;
    @Autowired
    private RecordGenerator recordGenerator;
    @Autowired
    private RecordSessionManager sessionManager;
    @Autowired
    private UserManager userManager;
    @Autowired
    private UserGroupManager userGroupManager;
    @Autowired
    private CollectJobManager jobManager;
    @Autowired
    private SessionRecordProvider sessionRecordProvider;
    @Autowired
    private RecordStatsGenerator recordStatsGenerator;
    @Autowired
    private transient EventQueue eventQueue;
    @Autowired
    private AppWS appWS;
    private CSVDataExportJob csvDataExportJob;
    private SurveyBackupJob fullBackupJob;
    private DataRestoreSummaryJob dataRestoreSummaryJob;
    private CSVDataImportJob csvDataImportJob;
    private ValidationReportJob validationReportJob;

    @RequestMapping(value={"survey/{surveyId}/data/records/{recordId}/binary_data.json"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, Object> loadData(@PathVariable(value="surveyId") int surveyId, @PathVariable(value="recordId") int recordId, @RequestParam(value="step") Integer stepNumber) throws Exception {
        stepNumber = this.getStepNumberOrDefault(stepNumber);
        CollectSurvey survey = this.surveyManager.getById(surveyId);
        byte[] data = this.recordManager.loadBinaryData(survey, recordId, CollectRecord.Step.valueOf((int)stepNumber));
        byte[] encoded = Base64.encodeBase64((byte[])data);
        String result = new String(encoded);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("data", result);
        return map;
    }

    @RequestMapping(value={"survey/{surveyId}/data/records/count.json"}, method={RequestMethod.GET})
    @ResponseBody
    public int getCount(@PathVariable(value="surveyId") int surveyId, @RequestParam(value="rootEntityDefinitionId", required=false) Integer rootEntityDefinitionId, @RequestParam(value="step", required=false) Integer stepNumber) throws Exception {
        CollectSurvey survey = this.surveyManager.getById(surveyId);
        RecordFilter filter = RecordController.createRecordFilter(survey, this.sessionManager.getLoggedUser(), this.userGroupManager, rootEntityDefinitionId, false);
        if (stepNumber != null) {
            filter.setStepGreaterOrEqual(CollectRecord.Step.valueOf((int)stepNumber));
        }
        int count = this.recordManager.countRecords(filter);
        return count;
    }

    @RequestMapping(value={"survey/{surveyId}/data/records/summary"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, Object> loadRecordSummaries(@PathVariable(value="surveyId") int surveyId, @Valid RecordSummarySearchParameters params) {
        CollectSurvey survey = this.surveyManager.getOrLoadSurveyById(surveyId);
        User user = this.loadUser(params.getUserId(), params.getUsername());
        HashMap<String, Object> result = new HashMap<String, Object>();
        Schema schema = survey.getSchema();
        EntityDefinition rootEntityDefinition = params.getRootEntityName() == null ? schema.getFirstRootEntityDefinition() : schema.getRootEntityDefinition(params.getRootEntityName());
        RecordFilter filter = RecordController.createRecordFilter(survey, user, this.userGroupManager, rootEntityDefinition.getId(), false);
        filter.setKeyValues(params.getKeyValues());
        filter.setCaseSensitiveKeyValues(params.isCaseSensitiveKeyValues());
        if (CollectionUtils.isEmpty((Collection)filter.getQualifiers())) {
            filter.setQualifiers(params.getQualifierValues());
        }
        filter.setSummaryValues(params.getSummaryValues());
        if (filter.getOwnerIds() == null && params.getOwnerIds() != null && params.getOwnerIds().length > 0) {
            filter.setOwnerIds(Arrays.asList(params.getOwnerIds()));
        }
        filter.setOffset(Integer.valueOf(params.getOffset()));
        filter.setMaxNumberOfRecords(Integer.valueOf(params.getMaxNumberOfRows()));
        List summaries = params.isFullSummary() ? this.recordManager.loadFullSummaries(filter, params.getSortFields()) : this.recordManager.loadSummaries(filter, params.getSortFields());
        result.put("records", this.toProxies(summaries));
        int count = this.recordManager.countRecords(filter);
        result.put("count", count);
        if (params.isIncludeOwners()) {
            Set owners = this.recordManager.loadDistinctOwners(RecordController.createRecordFilter(survey, user, this.userGroupManager, rootEntityDefinition.getId(), false));
            Set<BasicUserProxy> ownerProxies = Proxies.fromSet(owners, BasicUserProxy.class);
            result.put("owners", ownerProxies);
        }
        return result;
    }

    @RequestMapping(value={"survey/{surveyId}/data/records/{recordId}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public RecordProxy loadRecord(@PathVariable(value="surveyId") int surveyId, @PathVariable(value="recordId") int recordId, @RequestParam(value="step", required=false) Integer stepNumber, @RequestParam(value="lock", required=false, defaultValue="false") boolean lock) throws RecordPersistenceException {
        CollectSurvey survey = this.surveyManager.getById(surveyId);
        CollectRecord.Step step = stepNumber == null ? null : CollectRecord.Step.valueOf((int)stepNumber);
        User user = this.sessionManager.getLoggedUser();
        UserGroup surveyUserGrup = survey.getUserGroup();
        UserInGroup userInGroup = this.userGroupManager.findUserInGroupOrDescendants(surveyUserGrup.getId().intValue(), user.getId().intValue());
        if (userInGroup == null) {
            throw new IllegalArgumentException(String.format("User %s is not allowed to load record with id %d", user.getUsername(), recordId));
        }
        CollectRecordSummary recordSummary = this.recordManager.loadUniqueRecordSummary(survey, recordId);
        if (!(!user.hasRole(UserRole.ENTRY_LIMITED) && userInGroup.getRole() != UserInGroup.UserGroupRole.DATA_CLEANER_LIMITED || recordSummary.getOwner() != null && user.getId().equals(recordSummary.getOwner().getId()))) {
            throw new IllegalStateException(String.format("User '%s' (entry_limited) cannot access record with ID %d: he doesn't own it.", user.getUsername(), recordId));
        }
        CollectRecord record = lock ? this.recordManager.checkout(survey, user, recordId, step, this.sessionManager.getSessionState().getSessionId(), true) : this.recordManager.load(survey, recordId, step);
        this.sessionRecordProvider.putRecord(record);
        return this.toProxy(record);
    }

    @RequestMapping(value={"survey/{surveyId}/data/update/records/{recordId}"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public Response updateOwner(@PathVariable(value="surveyId") int surveyId, @PathVariable(value="recordId") int recordId, @RequestBody Map<String, String> body) throws RecordLockedException, MultipleEditException {
        String ownerIdStr = body.get("ownerId");
        Integer ownerId = ownerIdStr == null ? null : Integer.valueOf(Integer.parseInt(ownerIdStr));
        CollectSurvey survey = this.surveyManager.getById(surveyId);
        SessionState sessionState = this.sessionManager.getSessionState();
        this.recordManager.assignOwner(survey, recordId, ownerId, sessionState.getUser(), sessionState.getSessionId());
        return new Response();
    }

    @RequestMapping(value={"survey/{surveyId}/data/records/promote/{recordId}"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public Response promoteRecord(@PathVariable(value="surveyId") int surveyId, @PathVariable(value="recordId") int recordId) throws MissingRecordKeyException, RecordPromoteException {
        CollectSurvey survey = this.surveyManager.getById(surveyId);
        CollectRecord record = this.recordManager.load(survey, recordId);
        this.recordManager.promote(record, this.sessionManager.getLoggedUser(), true);
        return new Response();
    }

    @RequestMapping(value={"survey/{surveyId}/data/records/demote/{recordId}"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public Response demoteRecord(@PathVariable(value="surveyId") int surveyId, @PathVariable(value="recordId") int recordId) throws RecordPersistenceException {
        CollectSurvey survey = this.surveyManager.getById(surveyId);
        this.recordManager.demote(survey, recordId, this.sessionManager.getLoggedUser());
        return new Response();
    }

    @RequestMapping(value={"survey/{surveyId}/data/move/records"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public JobProxy moveRecords(@PathVariable(value="surveyId") int surveyId, final @RequestParam String fromStep, final @RequestParam boolean promote) {
        BulkRecordMoveJob job = (BulkRecordMoveJob)this.jobManager.createJob(BulkRecordMoveJob.class);
        SessionState sessionState = this.sessionManager.getSessionState();
        final User loggedUser = sessionState.getUser();
        CollectSurvey survey = this.surveyManager.getById(surveyId);
        EntityDefinition rootEntityDef = survey.getSchema().getFirstRootEntityDefinition();
        job.setSurvey(survey);
        job.setRootEntity(rootEntityDef.getName());
        job.setPromote(promote);
        job.setFromStep(CollectRecord.Step.valueOf((String)fromStep));
        job.setUser(loggedUser);
        job.setRecordMovedCallback(new BulkRecordMoveJob.Callback(){

            public void recordMoved(CollectRecord record) {
                if (promote) {
                    RecordController.this.publishRecordPromotedEvents(record, loggedUser.getUsername());
                } else {
                    RecordController.this.publishRecordDeletedEvent(record, RecordStep.valueOf((String)fromStep), loggedUser.getUsername());
                }
            }
        });
        this.sessionRecordProvider.clearRecords(surveyId);
        this.jobManager.startSurveyJob((SurveyLockingJob)job);
        return new JobProxy((Job)job);
    }

    @Transactional
    @RequestMapping(value={"survey/{surveyId}/data/records"}, method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseBody
    public RecordProxy newRecord(@PathVariable(value="surveyId") int surveyId, @RequestBody RecordGenerator.NewRecordParameters params) throws RecordPersistenceException {
        User user = this.sessionManager.getLoggedUser();
        if (user == null) {
            user = this.loadUser(params.getUserId(), params.getUsername());
        }
        CollectSurvey survey = params.isPreview() ? this.surveyManager.loadSurvey(surveyId) : this.surveyManager.getById(surveyId);
        params.setRootEntityName((String)ObjectUtils.defaultIfNull((Object)params.getRootEntityName(), (Object)survey.getSchema().getFirstRootEntityDefinition().getName()));
        Integer latestVersionId = survey.getLatestVersion() != null ? Integer.valueOf(survey.getLatestVersion().getId()) : null;
        params.setVersionId((Integer)ObjectUtils.defaultIfNull((Object)params.getVersionId(), (Object)latestVersionId));
        params.setUserId(user.getId());
        CollectRecord record = this.recordGenerator.generate(survey, params);
        this.sessionRecordProvider.putRecord(record);
        return this.toProxy(record);
    }

    @Transactional
    @RequestMapping(value={"survey/{surveyId}/data/records/random"}, method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseBody
    public RecordProxy createRandomRecord(@PathVariable(value="surveyId") int surveyId, @RequestBody RecordGenerator.NewRecordParameters params) throws RecordPersistenceException {
        CollectRecord record = this.randomRecordGenerator.generate(surveyId, params);
        return this.toProxy(record);
    }

    @RequestMapping(value={"survey/{surveyId}/data/records"}, method={RequestMethod.DELETE}, produces={"application/json"})
    @ResponseBody
    public Response deleteRecord(@PathVariable(value="surveyId") int surveyId, @Valid RecordDeleteParameters params) throws RecordPersistenceException {
        if (this.canDeleteRecords(surveyId, Sets.newHashSet((Object[])params.getRecordIds()))) {
            CollectSurvey survey = this.surveyManager.getById(surveyId);
            for (Integer recordId : params.getRecordIds()) {
                CollectRecord record = this.recordManager.load(survey, recordId.intValue());
                this.recordFileManager.deleteAllFiles(record);
                this.recordManager.delete(recordId.intValue());
                this.publishRecordDeletedEvent(record, record.getStep().toRecordStep(), this.sessionManager.getLoggedUser().getUsername());
            }
            return new Response();
        }
        Response response = new Response();
        response.setErrorStatus();
        response.setErrorMessage("Cannot delete some of the specified records: unsufficient user privilegies");
        return response;
    }

    @RequestMapping(value={"survey/{surveyId}/data/import/records/summary"}, method={RequestMethod.POST}, consumes={"multipart/form-data"})
    @ResponseBody
    public CollectJobController.JobView startRecordImportSummaryJob(@PathVariable(value="surveyId") int surveyId, @RequestParam(value="file") MultipartFile multipartFile, @RequestParam String rootEntityName) throws IOException {
        File tempFile = null;
        try {
            tempFile = File.createTempFile("ofc_data_restore", ".collect-data");
            tempFile.deleteOnExit();
            FileUtils.copyInputStreamToFile((InputStream)multipartFile.getInputStream(), (File)tempFile);
            CollectSurvey survey = this.surveyManager.getById(surveyId);
            DataRestoreSummaryJob job = (DataRestoreSummaryJob)this.jobManager.createJob(DataRestoreSummaryJob.class);
            job.setUser(this.sessionManager.getLoggedUser());
            job.setFullSummary(true);
            job.setFile(tempFile);
            job.setPublishedSurvey(survey);
            job.setCloseRecordProviderOnComplete(false);
            job.setDeleteInputFileOnDestroy(true);
            this.jobManager.start((Job)job);
            this.dataRestoreSummaryJob = job;
            return new CollectJobController.JobView((Job)job);
        }
        catch (Exception e) {
            FileUtils.deleteQuietly((File)tempFile);
            throw e;
        }
    }

    @RequestMapping(value={"survey/{surveyId}/data/import/records/summary"}, method={RequestMethod.GET})
    @ResponseBody
    public DataImportSummaryProxy downloadRecordImportSummary(@PathVariable(value="surveyId") int surveyId) throws IOException {
        if (this.dataRestoreSummaryJob == null || !this.dataRestoreSummaryJob.isCompleted()) {
            throw new IllegalStateException("Data restore summary not generated or an error occurred during the generation");
        }
        DataImportSummary summary = this.dataRestoreSummaryJob.getSummary();
        return new DataImportSummaryProxy(summary, this.sessionManager.getSessionState().getLocale());
    }

    @RequestMapping(value={"survey/{surveyId}/data/import/records"}, method={RequestMethod.POST})
    @ResponseBody
    public CollectJobController.JobView startRecordImport(@PathVariable(value="surveyId") int surveyId, @RequestParam List<Integer> entryIdsToImport, @RequestParam(defaultValue="true") boolean validateRecords) throws IOException {
        RecordProvider recordProvider = this.dataRestoreSummaryJob.getRecordProvider();
        if (recordProvider instanceof XMLParsingRecordProvider) {
            ((XMLParsingRecordProvider)recordProvider).setInitializeRecords(true);
        }
        recordProvider.setConfiguration(new RecordProviderConfiguration(true));
        DataRestoreJob job = (DataRestoreJob)this.jobManager.createJob(TransactionalDataRestoreJob.class);
        job.setFile(this.dataRestoreSummaryJob.getFile());
        job.setUser(this.sessionManager.getLoggedUser());
        job.setValidateRecords(validateRecords);
        job.setRecordProvider(recordProvider);
        job.setPackagedSurvey(this.dataRestoreSummaryJob.getPackagedSurvey());
        job.setPublishedSurvey(this.dataRestoreSummaryJob.getPublishedSurvey());
        job.setEntryIdsToImport(entryIdsToImport);
        job.setRecordFilesToBeDeleted(this.dataRestoreSummaryJob.getSummary().getConflictingRecordFiles(entryIdsToImport));
        job.setRestoreUploadedFiles(true);
        this.jobManager.start((Job)job);
        return new CollectJobController.JobView((Job)job);
    }

    @RequestMapping(value={"survey/{surveyId}/data/csvimport/records"}, method={RequestMethod.POST}, consumes={"multipart/form-data"})
    @ResponseBody
    public CollectJobController.JobView startCsvDataImportJob(@PathVariable(value="surveyId") int surveyId, @RequestParam(value="file") MultipartFile multipartFile, @RequestParam String rootEntityName, @RequestParam String importType, @RequestParam String steps, @RequestParam(required=false) Integer entityDefinitionId, @RequestParam(required=false) boolean validateRecords, @RequestParam(required=false) boolean deleteEntitiesBeforeImport, @RequestParam(required=false) String newRecordVersionName) throws IOException {
        File file = Files.writeToTempFile((InputStream)multipartFile.getInputStream(), (String)multipartFile.getOriginalFilename(), (String)"ofc_csv_data_import");
        CollectSurvey survey = this.surveyManager.getById(surveyId);
        CSVDataImportJob job = (CSVDataImportJob)this.jobManager.createJob(TransactionalCSVDataImportJob.class);
        CSVDataImportSettings settings = new CSVDataImportSettings();
        settings.setDeleteExistingEntities(deleteEntitiesBeforeImport);
        settings.setRecordValidationEnabled(validateRecords);
        settings.setInsertNewRecords("newRecords".equals(importType));
        settings.setNewRecordVersionName(newRecordVersionName);
        CSVDataImportJob.CSVDataImportInput input = new CSVDataImportJob.CSVDataImportInput(file, survey, this.fromStepNames(steps), entityDefinitionId, settings);
        job.setInput(input);
        this.jobManager.start((Job)job);
        this.csvDataImportJob = job;
        return new CollectJobController.JobView((Job)job);
    }

    @RequestMapping(value={"survey/{surveyId}/data/csvimport/records"}, method={RequestMethod.GET})
    @ResponseBody
    public DataImportStatusProxy getCsvDataImportStatus(@PathVariable(value="surveyId") int surveyId) {
        return new DataImportStatusProxy(this.csvDataImportJob);
    }

    private CollectRecord.Step[] fromStepNames(String stepNamesStr) {
        String[] stepNames = stepNamesStr.split(",");
        CollectRecord.Step[] steps = new CollectRecord.Step[stepNames.length];
        for (int i = 0; i < stepNames.length; ++i) {
            steps[i] = CollectRecord.Step.valueOf((String)stepNames[i]);
        }
        return steps;
    }

    @RequestMapping(value={"survey/{survey_id}/data/records/{record_id}/steps/{step}/content/csv/data.zip"}, method={RequestMethod.GET}, produces={"application/zip"})
    public void exportRecordToCsv(@PathVariable(value="survey_id") int surveyId, @PathVariable(value="record_id") int recordId, @PathVariable(value="step") int stepNumber, HttpServletResponse response) throws RecordPersistenceException, IOException {
        this.exportRecord(surveyId, recordId, stepNumber, CSVDataExportParametersBase.OutputFormat.CSV, response);
    }

    @RequestMapping(value={"survey/{survey_id}/data/records/{record_id}/steps/{step}/content/xlsx/data.zip"}, method={RequestMethod.GET}, produces={"application/zip"})
    public void exportRecordToExcel(@PathVariable(value="survey_id") int surveyId, @PathVariable(value="record_id") int recordId, @PathVariable(value="step") int stepNumber, HttpServletResponse response) throws RecordPersistenceException, IOException {
        this.exportRecord(surveyId, recordId, stepNumber, CSVDataExportParametersBase.OutputFormat.XLSX, response);
    }

    public void exportRecord(int surveyId, int recordId, int stepNumber, CSVDataExportParametersBase.OutputFormat outputFormat, HttpServletResponse response) throws RecordPersistenceException, IOException {
        CollectSurvey survey = this.surveyManager.getById(surveyId);
        CollectRecord record = this.recordManager.load(survey, recordId);
        RecordAccessControlManager accessControlManager = new RecordAccessControlManager();
        if (accessControlManager.canEdit(this.sessionManager.getLoggedUser(), record)) {
            CSVDataExportJob job = (CSVDataExportJob)this.jobManager.createJob(CSVDataExportJob.class);
            job.setSurvey(survey);
            CSVDataExportParameters parameters = new CSVDataExportParameters();
            RecordFilter recordFilter = RecordController.createRecordFilter(survey, this.sessionManager.getLoggedUser(), this.userGroupManager, null, false);
            recordFilter.setRecordId(Integer.valueOf(recordId));
            recordFilter.setStepGreaterOrEqual(CollectRecord.Step.valueOf((int)stepNumber));
            parameters.setRecordFilter(recordFilter);
            parameters.setAlwaysGenerateZipFile(true);
            parameters.setOutputFormat(outputFormat);
            job.setParameters(parameters);
            File outputFile = File.createTempFile("record_export", ".zip");
            job.setOutputFile(outputFile);
            this.jobManager.startSurveyJob((SurveyLockingJob)job, false);
            if (job.isCompleted()) {
                String fileName = String.format("record_data_%d_%s.zip", recordId, Dates.formatDate((Date)new Date()));
                Controllers.writeFileToResponse(response, outputFile, fileName, "application/zip");
            } else {
                if (job.getLastException() != null) {
                    throw new RuntimeException(job.getLastException());
                }
                throw new RuntimeException("Error exporting record");
            }
        }
    }

    @RequestMapping(value={"data/records/{recordId}/surveyId"}, method={RequestMethod.GET})
    @ResponseBody
    public int loadSurveyId(@PathVariable(value="recordId") int recordId) {
        return this.recordManager.loadSurveyId(recordId);
    }

    @RequestMapping(value={"survey/{surveyId}/data/records/startcsvexport"}, method={RequestMethod.POST})
    @ResponseBody
    public CollectJobController.JobView startCsvDataExportJob(@PathVariable(value="surveyId") int surveyId, @RequestBody CSVExportParametersForm parameters) throws IOException {
        User user = this.sessionManager.getLoggedUser();
        CollectSurvey survey = this.surveyManager.getById(surveyId);
        this.csvDataExportJob = (CSVDataExportJob)this.jobManager.createJob(CSVDataExportJob.class);
        this.csvDataExportJob.setSurvey(survey);
        this.csvDataExportJob.setOutputFile(File.createTempFile("collect-csv-data-export", ".zip"));
        CSVDataExportParameters exportParameters = parameters.toExportParameters(survey, user, this.userGroupManager);
        this.csvDataExportJob.setParameters(exportParameters);
        this.jobManager.start((Job)this.csvDataExportJob);
        return new CollectJobController.JobView((Job)this.csvDataExportJob);
    }

    @RequestMapping(value={"survey/{surveyId}/data/records/currentcsvexport"}, method={RequestMethod.GET})
    @ResponseBody
    public CollectJobController.JobView getCsvDataExportJob(HttpServletResponse response) {
        if (this.csvDataExportJob == null) {
            HttpResponses.setNoContentStatus((HttpServletResponse)response);
            return null;
        }
        return new CollectJobController.JobView((Job)this.csvDataExportJob);
    }

    @RequestMapping(value={"survey/{surveyId}/data/records/csvexportresult.zip"}, method={RequestMethod.GET})
    public void downloadCsvExportResult(HttpServletResponse response) throws FileNotFoundException, IOException {
        File file = this.csvDataExportJob.getOutputFile();
        RecordFilter recordFilter = this.csvDataExportJob.getParameters().getRecordFilter();
        CollectSurvey survey = recordFilter.getSurvey();
        String surveyName = survey.getName();
        CSVDataExportParameters parameters = this.csvDataExportJob.getParameters();
        String outputFormat = parameters.getOutputFormat().name().toLowerCase(Locale.ENGLISH);
        String step = parameters.getRecordFilter().getStepGreaterOrEqual().name();
        String fileName = String.format("collect-%s-data-export-%s-%s-%s.zip", outputFormat, surveyName, step, Dates.formatLocalDateTime((Date)new Date()));
        Controllers.writeFileToResponse(response, file, fileName, "application/zip");
    }

    @RequestMapping(value={"survey/{surveyId}/data/records/startbackupexport"}, method={RequestMethod.POST})
    @ResponseBody
    public CollectJobController.JobView startBackupDataExportJob(@PathVariable(value="surveyId") int surveyId, @RequestBody BackupDataExportParameters parameters) throws IOException {
        User user = this.sessionManager.getLoggedUser();
        CollectSurvey survey = this.surveyManager.getById(surveyId);
        RecordFilter filter = RecordController.createRecordFilter(survey, user, this.userGroupManager, null, parameters.onlyOwnedRecords);
        this.fullBackupJob = (SurveyBackupJob)this.jobManager.createJob(SurveyBackupJob.class);
        this.fullBackupJob.setRecordFilter(filter);
        this.fullBackupJob.setSurvey(survey);
        this.fullBackupJob.setIncludeData(true);
        this.fullBackupJob.setIncludeRecordFiles(parameters.isIncludeRecordFiles());
        this.jobManager.start((Job)this.fullBackupJob);
        return this.getFullBackupJobView();
    }

    @RequestMapping(value={"survey/{surveyId}/data/records/exportresult.collect-data"}, method={RequestMethod.GET})
    public void downloadBackupExportResult(HttpServletResponse response) throws FileNotFoundException, IOException {
        File file = this.fullBackupJob.getOutputFile();
        CollectSurvey survey = this.fullBackupJob.getSurvey();
        String surveyName = survey.getName();
        Controllers.writeFileToResponse(response, file, String.format("%s-%s.collect-data", surveyName, Dates.formatLocalDateTime((Date)new Date())), "application/zip");
    }

    @RequestMapping(value={"survey/{survey_id}/data/records/{record_id}/content/collect/data.collect-data"}, method={RequestMethod.GET}, produces={"application/zip"})
    public void exportRecordToCollectFormat(@PathVariable(value="survey_id") int surveyId, @PathVariable(value="record_id") int recordId, HttpServletResponse response) throws RecordPersistenceException, IOException {
        User user = this.sessionManager.getLoggedUser();
        CollectSurvey survey = this.surveyManager.getById(surveyId);
        RecordFilter filter = RecordController.createRecordFilter(survey, user, this.userGroupManager);
        filter.setRecordId(Integer.valueOf(recordId));
        List summaries = this.recordManager.loadSummaries(filter);
        if (summaries.size() != 1) {
            throw new IllegalArgumentException(String.format("Could not find record with id %d or multiple records found", recordId));
        }
        CollectRecordSummary recordSummary = (CollectRecordSummary)summaries.get(0);
        SurveyBackupJob job = (SurveyBackupJob)this.jobManager.createJob(SurveyBackupJob.class);
        job.setRecordFilter(filter);
        job.setSurvey(survey);
        job.setIncludeData(true);
        job.setIncludeRecordFiles(true);
        this.jobManager.start((Job)job, false);
        File file = job.getOutputFile();
        String surveyName = survey.getName();
        String recordKeys = StringUtils.join((Iterable)recordSummary.getRootEntityKeyValues(), (char)'-');
        String outputFileName = String.format("%s-record-%s-%s.collect-data", surveyName, recordKeys, Dates.formatLocalDateTime((Date)new Date()));
        Controllers.writeFileToResponse(response, file, outputFileName, "application/zip");
    }

    @RequestMapping(value={"survey/{surveyId}/data/records/stats"}, method={RequestMethod.GET})
    @ResponseBody
    public RecordStatsGenerator.RecordsStats generateStats(@PathVariable(value="surveyId") int surveyId) {
        Date[] period = this.recordManager.findWorkingPeriod(surveyId);
        if (period == null) {
            return RecordStatsGenerator.RecordsStats.EMPTY;
        }
        RecordStatsGenerator.RecordsStats stats = this.recordStatsGenerator.generate(surveyId, period);
        return stats;
    }

    @RequestMapping(value={"survey/{surveyId}/data/records/validationreport"}, method={RequestMethod.POST})
    @ResponseBody
    public JobProxy startValidationResportJob(@PathVariable(value="surveyId") int surveyId) {
        User user = this.sessionManager.getLoggedUser();
        Locale locale = this.sessionManager.getSessionState().getLocale();
        CollectSurvey survey = this.surveyManager.getById(surveyId);
        EntityDefinition rootEntityDef = survey.getSchema().getFirstRootEntityDefinition();
        ValidationReportJob job = (ValidationReportJob)this.jobManager.createJob(ValidationReportJob.class);
        ValidationReportJob.Input input = new ValidationReportJob.Input();
        input.setLocale(locale);
        input.setReportType(ValidationReportJob.ReportType.CSV);
        RecordFilter recordFilter = RecordController.createRecordFilter(survey, user, this.userGroupManager, rootEntityDef.getId(), false);
        input.setRecordFilter(recordFilter);
        job.setInput(input);
        this.validationReportJob = job;
        this.jobManager.start((Job)job);
        return new JobProxy(job);
    }

    @RequestMapping(value={"survey/{surveyId}/data/records/validationreport.csv"}, method={RequestMethod.GET})
    public void downloadValidationReportResult(HttpServletResponse response) throws FileNotFoundException, IOException {
        File file = this.validationReportJob.getOutputFile();
        CollectSurvey survey = this.validationReportJob.getInput().getRecordFilter().getSurvey();
        String surveyName = survey.getName();
        Controllers.writeFileToResponse(response, file, String.format("collect-validation-report-%s-%s.csv", surveyName, Dates.formatDate((Date)new Date())), "text/csv");
    }

    @RequestMapping(value={"survey/{surveyId}/data/records/backupexportjob"}, method={RequestMethod.GET})
    @ResponseBody
    public CollectJobController.JobView getFullBackupJobView() {
        if (this.fullBackupJob == null) {
            return null;
        }
        CollectJobController.JobView jobView = new CollectJobController.JobView((Job)this.fullBackupJob);
        jobView.putExtra("dataBackupErrors", this.fullBackupJob.getDataBackupErrors());
        return jobView;
    }

    @RequestMapping(value={"survey/{surveyId}/data/records/releaselock/{recordId}"}, method={RequestMethod.POST})
    @ResponseBody
    public Response releaseRecordLock(@PathVariable int recordId) {
        CollectRecord activeRecord = this.sessionManager.getActiveRecord();
        Response res = new Response();
        if (activeRecord != null && activeRecord.getId() != null && activeRecord.getId().equals(recordId)) {
            this.recordManager.releaseLock(Integer.valueOf(recordId));
            this.sessionManager.clearActiveRecord();
            this.appWS.sendMessage(new AppWS.RecordUnlockedMessage(recordId));
        } else {
            res.setErrorStatus();
            res.setErrorMessage(String.format("Cannot unlock record with id %d: it is not being edited by user %s", recordId, this.sessionManager.getLoggedUsername()));
        }
        return res;
    }

    private Integer getStepNumberOrDefault(Integer stepNumber) {
        if (stepNumber == null) {
            stepNumber = CollectRecord.Step.ENTRY.getStepNumber();
        }
        return stepNumber;
    }

    private RecordProxy toProxy(CollectRecord record) {
        String defaultLanguage = record.getSurvey().getDefaultLanguage();
        Locale locale = new Locale(defaultLanguage);
        ProxyContext context = new ProxyContext(locale, this.messageSource, (SurveyContext)this.surveyContext);
        return new RecordProxy(record, context);
    }

    private List<RecordSummaryProxy> toProxies(List<CollectRecordSummary> summaries) {
        ArrayList<RecordSummaryProxy> result = new ArrayList<RecordSummaryProxy>(summaries.size());
        for (CollectRecordSummary summary : summaries) {
            result.add(this.toSummaryProxy(summary));
        }
        return result;
    }

    private RecordSummaryProxy toSummaryProxy(CollectRecordSummary summary) {
        ProxyContext context = new ProxyContext(this.sessionManager.getSessionState().getLocale(), this.messageSource, (SurveyContext)this.surveyContext);
        return new RecordSummaryProxy(summary, context);
    }

    private void publishRecordPromotedEvents(CollectRecord record, String userName) {
        if (!this.eventQueue.isEnabled()) {
            return;
        }
        SessionState sessionState = this.sessionManager.getSessionState();
        EventProducer.EventProducerContext context = new EventProducer.EventProducerContext(this.messageSource, sessionState.getLocale(), userName);
        EventListenerToList consumer = new EventListenerToList();
        new EventProducer(context, (EventListener)consumer).produceFor(record);
        this.eventQueue.publish(new RecordTransaction(record.getSurvey().getName(), record.getId().intValue(), record.getStep().toRecordStep(), consumer.getList()));
    }

    private void publishRecordDeletedEvent(CollectRecord record, RecordStep recordStep, String userName) {
        if (!this.eventQueue.isEnabled()) {
            return;
        }
        List<RecordDeletedEvent> events = Arrays.asList(new RecordDeletedEvent(record.getSurvey().getName(), record.getId().intValue(), new Date(), userName));
        String surveyName = record.getSurvey().getName();
        this.eventQueue.publish(new RecordTransaction(surveyName, record.getId().intValue(), recordStep, events));
    }

    private User loadUser(Integer userId, String username) {
        if (userId != null) {
            return (User)this.userManager.loadById((Object)userId);
        }
        if (username != null) {
            return this.userManager.loadByUserName(username);
        }
        return null;
    }

    private boolean canDeleteRecords(int surveyId, Set<Integer> recordIds) {
        CollectSurvey survey = this.surveyManager.getById(surveyId);
        RecordFilter filter = new RecordFilter(survey);
        filter.setRecordIds(recordIds);
        List recordSummaries = this.recordManager.loadSummaries(filter);
        User loggedUser = this.sessionManager.getLoggedUser();
        RecordAccessControlManager recordAccessControlManager = new RecordAccessControlManager();
        UserInGroup userInSurveyGroup = this.userGroupManager.findUserInGroupOrDescendants(survey.getUserGroupId().intValue(), loggedUser.getId().intValue());
        boolean canDeleteRecords = userInSurveyGroup != null && recordAccessControlManager.canDeleteRecords(loggedUser, userInSurveyGroup.getRole(), (Collection)recordSummaries);
        return canDeleteRecords;
    }

    private static RecordFilter createRecordFilter(CollectSurvey survey, User user, UserGroupManager userGroupManager) {
        return RecordController.createRecordFilter(survey, user, userGroupManager, null, false);
    }

    private static RecordFilter createRecordFilter(CollectSurvey survey, User user, UserGroupManager userGroupManager, Integer rootEntityId, boolean onlyOwnedRecords) {
        return RecordController.createRecordFilter(survey, user, userGroupManager, rootEntityId, onlyOwnedRecords, null, null);
    }

    private static RecordFilter createRecordFilter(CollectSurvey survey, User user, UserGroupManager userGroupManager, Integer rootEntityId, boolean onlyOwnedRecords, Date modifiedSince, Date modifiedUntil) {
        Map qualifiers;
        if (rootEntityId == null) {
            rootEntityId = survey.getSchema().getFirstRootEntityDefinition().getId();
        }
        UserInGroup userInGroup = userGroupManager.findUserInGroupOrDescendants(survey.getUserGroupId().intValue(), user.getId().intValue());
        RecordFilter recordFilter = new RecordFilter(survey);
        recordFilter.setRootEntityId(rootEntityId);
        if (onlyOwnedRecords || user.getRole() == UserRole.ENTRY_LIMITED || userInGroup != null && userInGroup.getRole() == UserInGroup.UserGroupRole.DATA_CLEANER_LIMITED) {
            recordFilter.setOwnerId(user.getId().intValue());
        }
        if (user.getRole() != UserRole.ADMIN && !(qualifiers = userGroupManager.getQualifiers(survey.getUserGroupId().intValue(), user.getId().intValue())).isEmpty()) {
            recordFilter.setQualifiersByName(qualifiers);
        }
        recordFilter.setModifiedSince(modifiedSince);
        recordFilter.setModifiedUntil(modifiedUntil);
        return recordFilter;
    }

    public static class CSVExportParametersForm
    extends CSVDataExportParametersBase {
        private Integer surveyId;
        private Integer rootEntityId;
        private Integer recordId;
        private CollectRecord.Step stepGreaterOrEqual;
        private boolean exportOnlyOwnedRecords = false;
        private Date modifiedSince;
        private Date modifiedUntil;
        private List<String> keyAttributeValues = new ArrayList<String>();
        private List<String> summaryAttributeValues = new ArrayList<String>();

        public CSVDataExportParameters toExportParameters(CollectSurvey survey, User user, UserGroupManager userGroupManager) {
            CSVDataExportParameters result = new CSVDataExportParameters();
            RecordFilter recordFilter = RecordController.createRecordFilter(survey, user, userGroupManager, this.rootEntityId, this.exportOnlyOwnedRecords, this.modifiedSince, this.modifiedUntil);
            recordFilter.setStepGreaterOrEqual(this.stepGreaterOrEqual);
            recordFilter.setKeyValues(this.keyAttributeValues);
            recordFilter.setSummaryValues(this.summaryAttributeValues);
            result.setRecordFilter(recordFilter);
            try {
                PropertyUtils.copyProperties((Object)result, (Object)((Object)this));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return result;
        }

        public Integer getSurveyId() {
            return this.surveyId;
        }

        public void setSurveyId(Integer surveyId) {
            this.surveyId = surveyId;
        }

        public Integer getRootEntityId() {
            return this.rootEntityId;
        }

        public void setRootEntityId(Integer rootEntityId) {
            this.rootEntityId = rootEntityId;
        }

        public Integer getRecordId() {
            return this.recordId;
        }

        public void setRecordId(Integer recordId) {
            this.recordId = recordId;
        }

        public CollectRecord.Step getStepGreaterOrEqual() {
            return this.stepGreaterOrEqual;
        }

        public void setStepGreaterOrEqual(CollectRecord.Step stepGreaterOrEqual) {
            this.stepGreaterOrEqual = stepGreaterOrEqual;
        }

        public boolean isExportOnlyOwnedRecords() {
            return this.exportOnlyOwnedRecords;
        }

        public void setExportOnlyOwnedRecords(boolean exportOnlyOwnedRecords) {
            this.exportOnlyOwnedRecords = exportOnlyOwnedRecords;
        }

        public Date getModifiedSince() {
            return this.modifiedSince;
        }

        public void setModifiedSince(Date modifiedSince) {
            this.modifiedSince = modifiedSince;
        }

        public Date getModifiedUntil() {
            return this.modifiedUntil;
        }

        public void setModifiedUntil(Date modifiedUntil) {
            this.modifiedUntil = modifiedUntil;
        }

        public List<String> getKeyAttributeValues() {
            return this.keyAttributeValues;
        }

        public void setKeyAttributeValues(List<String> keyAttributeValues) {
            this.keyAttributeValues = keyAttributeValues;
        }

        public List<String> getSummaryAttributeValues() {
            return this.summaryAttributeValues;
        }

        public void setSummaryAttributeValues(List<String> summaryAttributeValues) {
            this.summaryAttributeValues = summaryAttributeValues;
        }
    }

    public static class BackupDataExportParameters {
        private boolean onlyOwnedRecords;
        private boolean includeRecordFiles;
        private List<String> rootEntityKeyValues;

        public boolean isOnlyOwnedRecords() {
            return this.onlyOwnedRecords;
        }

        public void setOnlyOwnedRecords(boolean onlyOwnedRecords) {
            this.onlyOwnedRecords = onlyOwnedRecords;
        }

        public boolean isIncludeRecordFiles() {
            return this.includeRecordFiles;
        }

        public void setIncludeRecordFiles(boolean includeRecordFiles) {
            this.includeRecordFiles = includeRecordFiles;
        }

        public List<String> getRootEntityKeyValues() {
            return this.rootEntityKeyValues;
        }

        public void setRootEntityKeyValues(List<String> rootEntityKeyValues) {
            this.rootEntityKeyValues = rootEntityKeyValues;
        }
    }

    public static class RecordDeleteParameters {
        private int userId;
        private Integer[] recordIds;

        public int getUserId() {
            return this.userId;
        }

        public void setUserId(int userId) {
            this.userId = userId;
        }

        public Integer[] getRecordIds() {
            return this.recordIds;
        }

        public void setRecordIds(Integer[] recordIds) {
            this.recordIds = recordIds;
        }
    }

    public static class RecordSummarySearchParameters
    extends SearchParameters {
        private String username;
        private Integer userId;
        private String rootEntityName;
        private List<RecordSummarySortField> sortFields;
        private String[] keyValues;
        private boolean caseSensitiveKeyValues = false;
        private String[] qualifierValues;
        private String[] summaryValues;
        private Integer[] ownerIds;
        private boolean fullSummary = false;
        private boolean includeOwners = false;

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public Integer getUserId() {
            return this.userId;
        }

        public void setUserId(Integer userId) {
            this.userId = userId;
        }

        public String getRootEntityName() {
            return this.rootEntityName;
        }

        public void setRootEntityName(String rootEntityName) {
            this.rootEntityName = rootEntityName;
        }

        public List<RecordSummarySortField> getSortFields() {
            return this.sortFields;
        }

        public void setSortFields(List<RecordSummarySortField> sortFields) {
            this.sortFields = sortFields;
        }

        public String[] getKeyValues() {
            return this.keyValues;
        }

        public void setKeyValues(String[] keyValues) {
            this.keyValues = keyValues;
        }

        public String[] getQualifierValues() {
            return this.qualifierValues;
        }

        public void setQualifierValues(String[] qualifierValues) {
            this.qualifierValues = qualifierValues;
        }

        public String[] getSummaryValues() {
            return this.summaryValues;
        }

        public void setSummaryValues(String[] summaryValues) {
            this.summaryValues = summaryValues;
        }

        public boolean isCaseSensitiveKeyValues() {
            return this.caseSensitiveKeyValues;
        }

        public void setCaseSensitiveKeyValues(boolean caseSensitiveKeyValues) {
            this.caseSensitiveKeyValues = caseSensitiveKeyValues;
        }

        public boolean isFullSummary() {
            return this.fullSummary;
        }

        public void setFullSummary(boolean fullSummary) {
            this.fullSummary = fullSummary;
        }

        public Integer[] getOwnerIds() {
            return this.ownerIds;
        }

        public void setOwnerIds(Integer[] ownerIds) {
            this.ownerIds = ownerIds;
        }

        public boolean isIncludeOwners() {
            return this.includeOwners;
        }

        public void setIncludeOwners(boolean includeOwners) {
            this.includeOwners = includeOwners;
        }
    }

    public static class SearchParameters {
        private int offset;
        private int maxNumberOfRows;

        public int getOffset() {
            return this.offset;
        }

        public void setOffset(int offset) {
            this.offset = offset;
        }

        public int getMaxNumberOfRows() {
            return this.maxNumberOfRows;
        }

        public void setMaxNumberOfRows(int maxNumberOfRows) {
            this.maxNumberOfRows = maxNumberOfRows;
        }
    }
}

