/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.form.validator;

import org.openforis.collect.designer.form.validator.CheckFormValidator;
import org.openforis.commons.lang.Strings;
import org.openforis.idm.metamodel.NodeDefinition;
import org.openforis.idm.metamodel.expression.ExpressionValidator;
import org.zkoss.bind.ValidationContext;

public class UniquenessCheckFormValidator
extends CheckFormValidator {
    protected static final String EXPRESSION_FIELD = "expression";

    @Override
    protected void internalValidate(ValidationContext ctx) {
        super.internalValidate(ctx);
        this.validateExpression(ctx);
    }

    private boolean validateExpression(ValidationContext ctx) {
        if (this.validateRequired(ctx, EXPRESSION_FIELD)) {
            ExpressionValidator expressionValidator = this.getExpressionValidator(ctx);
            NodeDefinition contextNode = this.getContextNode(ctx);
            String expression = (String)this.getValue(ctx, EXPRESSION_FIELD);
            ExpressionValidator.ExpressionValidationResult result = expressionValidator.validateUniquenessExpression(contextNode.getParentDefinition(), contextNode, expression);
            if (result.isError()) {
                String message = Strings.firstNotBlank((String[])new String[]{result.getDetailedMessage(), result.getMessage()});
                this.addInvalidMessage(ctx, EXPRESSION_FIELD, UniquenessCheckFormValidator.getMessage("survey.validation.error.invalid_expression", message));
                return false;
            }
        }
        return true;
    }
}

