/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.datacleansing.persistence;

import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SelectConditionStep;
import org.jooq.SelectSeekStep1;
import org.jooq.StoreQuery;
import org.jooq.Table;
import org.openforis.collect.datacleansing.DataQuery;
import org.openforis.collect.datacleansing.DataQueryType;
import org.openforis.collect.datacleansing.persistence.DataCleansingItemDao;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.persistence.jooq.Sequences;
import org.openforis.collect.persistence.jooq.SurveyObjectMappingDSLContext;
import org.openforis.collect.persistence.jooq.tables.OfcDataQuery;
import org.openforis.idm.metamodel.PersistedSurveyObject;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="dataQueryDao")
@Transactional
public class DataQueryDao
extends DataCleansingItemDao<DataQuery, JooqDSLContext> {
    public DataQueryDao() {
        super(JooqDSLContext.class);
    }

    public List<DataQuery> loadBySurvey(CollectSurvey survey) {
        JooqDSLContext dsl = (JooqDSLContext)this.dsl(survey);
        SelectSeekStep1 select = dsl.selectFrom((Table)OfcDataQuery.OFC_DATA_QUERY).where(new Condition[]{OfcDataQuery.OFC_DATA_QUERY.SURVEY_ID.eq((Object)survey.getId())}).orderBy((Field)OfcDataQuery.OFC_DATA_QUERY.TITLE);
        Result result = select.fetch();
        return dsl.fromResult(result);
    }

    public void deleteBySurvey(CollectSurvey survey) {
        ((JooqDSLContext)this.dsl()).delete((Table)OfcDataQuery.OFC_DATA_QUERY).where(new Condition[]{OfcDataQuery.OFC_DATA_QUERY.SURVEY_ID.eq((Object)survey.getId())}).execute();
    }

    public List<DataQuery> loadByType(DataQueryType type) {
        JooqDSLContext dsl = (JooqDSLContext)this.dsl((CollectSurvey)type.getSurvey());
        SelectConditionStep select = dsl.selectFrom((Table)OfcDataQuery.OFC_DATA_QUERY).where(new Condition[]{OfcDataQuery.OFC_DATA_QUERY.TYPE_ID.eq((Object)((Integer)type.getId()))});
        Result result = select.fetch();
        return dsl.fromResult(result);
    }

    protected static class JooqDSLContext
    extends SurveyObjectMappingDSLContext<Integer, DataQuery> {
        private static final long serialVersionUID = 1L;

        public JooqDSLContext(Configuration config) {
            this(config, null);
        }

        public JooqDSLContext(Configuration config, CollectSurvey survey) {
            super(config, OfcDataQuery.OFC_DATA_QUERY.ID, Sequences.OFC_DATA_QUERY_ID_SEQ, DataQuery.class, survey);
        }

        protected DataQuery newEntity() {
            return new DataQuery(this.getSurvey());
        }

        protected void fromRecord(Record r, DataQuery o) {
            super.fromRecord(r, (PersistedSurveyObject)o);
            o.setAttributeDefinitionId((Integer)r.getValue((Field)OfcDataQuery.OFC_DATA_QUERY.ATTRIBUTE_ID));
            o.setConditions((String)r.getValue((Field)OfcDataQuery.OFC_DATA_QUERY.CONDITIONS));
            o.setCreationDate((Date)r.getValue((Field)OfcDataQuery.OFC_DATA_QUERY.CREATION_DATE));
            o.setErrorSeverity(this.extractSeverity(r));
            o.setModifiedDate((Date)r.getValue((Field)OfcDataQuery.OFC_DATA_QUERY.MODIFIED_DATE));
            o.setDescription((String)r.getValue((Field)OfcDataQuery.OFC_DATA_QUERY.DESCRIPTION));
            o.setEntityDefinitionId((Integer)r.getValue((Field)OfcDataQuery.OFC_DATA_QUERY.ENTITY_ID));
            o.setTitle((String)r.getValue((Field)OfcDataQuery.OFC_DATA_QUERY.TITLE));
            o.setTypeId((Integer)r.getValue((Field)OfcDataQuery.OFC_DATA_QUERY.TYPE_ID));
            o.setUuid(UUID.fromString((String)r.getValue((Field)OfcDataQuery.OFC_DATA_QUERY.UUID)));
        }

        private DataQuery.ErrorSeverity extractSeverity(Record r) {
            String severityCode = (String)r.getValue((Field)OfcDataQuery.OFC_DATA_QUERY.SEVERITY);
            DataQuery.ErrorSeverity severity = null;
            if (StringUtils.isNotBlank((CharSequence)severityCode)) {
                severity = DataQuery.ErrorSeverity.fromCode(severityCode);
            }
            return severity;
        }

        protected void fromObject(DataQuery o, StoreQuery<?> q) {
            super.fromObject((PersistedSurveyObject)o, q);
            q.addValue((Field)OfcDataQuery.OFC_DATA_QUERY.ATTRIBUTE_ID, (Object)o.getAttributeDefinitionId());
            q.addValue((Field)OfcDataQuery.OFC_DATA_QUERY.CONDITIONS, (Object)o.getConditions());
            q.addValue((Field)OfcDataQuery.OFC_DATA_QUERY.CREATION_DATE, (Object)DataQueryDao.toTimestamp((Date)o.getCreationDate()));
            q.addValue((Field)OfcDataQuery.OFC_DATA_QUERY.DESCRIPTION, (Object)o.getDescription());
            q.addValue((Field)OfcDataQuery.OFC_DATA_QUERY.ENTITY_ID, (Object)o.getEntityDefinitionId());
            q.addValue((Field)OfcDataQuery.OFC_DATA_QUERY.MODIFIED_DATE, (Object)DataQueryDao.toTimestamp((Date)o.getModifiedDate()));
            DataQuery.ErrorSeverity severity = o.getErrorSeverity();
            String severityCode = severity == null ? null : String.valueOf(severity.getCode());
            q.addValue((Field)OfcDataQuery.OFC_DATA_QUERY.SEVERITY, (Object)severityCode);
            q.addValue((Field)OfcDataQuery.OFC_DATA_QUERY.SURVEY_ID, (Object)o.getSurvey().getId());
            q.addValue((Field)OfcDataQuery.OFC_DATA_QUERY.TITLE, (Object)o.getTitle());
            q.addValue((Field)OfcDataQuery.OFC_DATA_QUERY.TYPE_ID, (Object)o.getTypeId());
            q.addValue((Field)OfcDataQuery.OFC_DATA_QUERY.UUID, (Object)o.getUuid().toString());
        }
    }
}

