/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.form.validator;

import org.openforis.collect.designer.form.validator.CheckFormValidator;
import org.openforis.commons.lang.Strings;
import org.openforis.idm.metamodel.expression.ExpressionValidator;
import org.zkoss.bind.ValidationContext;

public class PatternCheckFormValidator
extends CheckFormValidator {
    protected static final String REGULAR_EXPRESSION_FIELD = "regularExpression";

    @Override
    protected void internalValidate(ValidationContext ctx) {
        super.internalValidate(ctx);
        this.validateExpression(ctx);
    }

    private boolean validateExpression(ValidationContext ctx) {
        String expression;
        if (!this.validateRequired(ctx, REGULAR_EXPRESSION_FIELD)) {
            return false;
        }
        ExpressionValidator expressionValidator = this.getExpressionValidator(ctx);
        ExpressionValidator.ExpressionValidationResult result = expressionValidator.validateRegularExpression(expression = (String)this.getValue(ctx, REGULAR_EXPRESSION_FIELD));
        if (result.isError()) {
            String message = Strings.firstNotBlank((String[])new String[]{result.getDetailedMessage(), result.getMessage()});
            this.addInvalidMessage(ctx, REGULAR_EXPRESSION_FIELD, PatternCheckFormValidator.getMessage("survey.validation.error.invalid_expression", message));
            return false;
        }
        return true;
    }
}

