/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.web.controller;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openforis.collect.concurrency.CollectJobManager;
import org.openforis.collect.io.BackupFileExtractor;
import org.openforis.collect.io.SurveyBackupInfo;
import org.openforis.collect.io.data.DataRestoreJob;
import org.openforis.collect.io.data.DataRestoreTask;
import org.openforis.collect.manager.ConfigurationManager;
import org.openforis.collect.manager.SessionManager;
import org.openforis.collect.manager.SurveyManager;
import org.openforis.collect.manager.UserGroupManager;
import org.openforis.collect.manager.UserManager;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.model.Configuration;
import org.openforis.collect.model.User;
import org.openforis.collect.model.UserGroup;
import org.openforis.collect.web.controller.BasicController;
import org.openforis.collect.web.controller.upload.UploadItem;
import org.openforis.collect.web.ws.AppWS;
import org.openforis.commons.web.JobStatusResponse;
import org.openforis.concurrency.Job;
import org.openforis.concurrency.Worker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.security.access.annotation.Secured;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"api"})
@Scope(value="session")
public class DataRestoreController
extends BasicController {
    private static final Logger LOG = LogManager.getLogger(DataRestoreController.class);
    @Autowired
    private SurveyManager surveyManager;
    @Autowired
    private ConfigurationManager configurationManager;
    @Autowired
    private CollectJobManager jobManager;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private UserManager userManager;
    @Autowired
    private UserGroupManager userGroupManager;
    @Autowired
    private AppWS appWS;

    @Secured(value={"ROLE_ENTRY"})
    @RequestMapping(value={"/surveys/restore/data"}, method={RequestMethod.POST}, consumes={"multipart/form-data"})
    @ResponseBody
    public JobStatusResponse restoreData(@RequestParam(value="file") MultipartFile multipartFile, @RequestParam(required=false) String surveyName, @RequestParam(required=false, defaultValue="true") boolean validateRecords, @RequestParam(required=false, defaultValue="false") boolean deleteAllRecordsBeforeImport, @RequestParam(required=false, defaultValue="OVERWRITE_OLDER") String recordOverwriteStrategy) throws IOException {
        User loggedUser = this.sessionManager.getLoggedUser();
        try {
            DataRestoreJob job = this.startRestoreJob(multipartFile.getInputStream(), surveyName == null, surveyName, loggedUser, validateRecords, deleteAllRecordsBeforeImport, DataRestoreTask.OverwriteStrategy.valueOf((String)recordOverwriteStrategy));
            return this.createResponse((Job)job);
        }
        catch (Exception e) {
            LOG.error((Object)e);
            JobStatusResponse response = new JobStatusResponse();
            response.setErrorStatus();
            response.setErrorMessage(e.getMessage());
            return response;
        }
    }

    @RequestMapping(value={"/surveys/{surveyName}/data/restoreremotely.json"}, method={RequestMethod.POST})
    @ResponseBody
    public RemoteDataRestoreResponse restoreDataRemotely(UploadItem uploadItem, @PathVariable String surveyName, @RequestParam String restoreKey) {
        RemoteDataRestoreResponse response = new RemoteDataRestoreResponse();
        String allowedRestoreKey = this.configurationManager.getConfiguration().get(Configuration.ConfigurationItem.ALLOWED_RESTORE_KEY);
        if (StringUtils.isBlank((CharSequence)allowedRestoreKey) || allowedRestoreKey.equals(restoreKey)) {
            try {
                User user = this.userManager.loadAdminUser();
                boolean newSurvey = this.surveyManager.get(surveyName) == null;
                DataRestoreJob job = this.startRestoreJob(uploadItem.getFileData().getInputStream(), newSurvey, surveyName, user, true, false, DataRestoreTask.OverwriteStrategy.OVERWRITE_OLDER);
                response.setJobId(job.getId().toString());
            }
            catch (Exception e) {
                LOG.error((Object)e);
                response.setErrorStatus();
                response.setErrorMessage(e.getMessage());
            }
        } else {
            response.setErrorStatus();
            response.setErrorMessage("Restore not allowed: invalid restore key");
        }
        return response;
    }

    @Secured(value={"ROLE_ENTRY"})
    @RequestMapping(value={"/surveys/data/restorejobs/{jobId}/status.json"}, method={RequestMethod.GET})
    @ResponseBody
    public RemoteDataRestoreResponse getRestoreDataRemotelyStatus(@PathVariable String jobId) throws IOException {
        RemoteDataRestoreResponse response;
        Job job = this.jobManager.getJob(jobId);
        if (job == null || !(job instanceof DataRestoreJob)) {
            response = new RemoteDataRestoreResponse();
            response.setErrorStatus();
            response.setErrorMessage("Job not found");
        } else {
            response = this.createRemoteDataRestoreResponse(job);
        }
        return response;
    }

    @RequestMapping(value={"/surveys/data/restore/jobs/{jobId}/abort.json"}, method={RequestMethod.GET})
    @ResponseBody
    public RemoteDataRestoreResponse abortRestoreDataRemotelyJob(@PathVariable String jobId) throws IOException {
        RemoteDataRestoreResponse response;
        Job job = this.jobManager.getJob(jobId);
        if (job == null || !(job instanceof DataRestoreJob)) {
            response = new RemoteDataRestoreResponse();
            response.setErrorStatus();
            response.setErrorMessage("Job not found");
        } else {
            job.abort();
            response = this.createRemoteDataRestoreResponse(job);
        }
        return response;
    }

    private JobStatusResponse createResponse(Job job) {
        JobStatusResponse response = new JobStatusResponse();
        this.fillResponse(response, job);
        return response;
    }

    private RemoteDataRestoreResponse createRemoteDataRestoreResponse(Job job) {
        RemoteDataRestoreResponse response = new RemoteDataRestoreResponse();
        this.fillResponse(response, job);
        return response;
    }

    private void fillResponse(JobStatusResponse response, Job job) {
        response.setJobId(job.getId().toString());
        response.setJobStatus(job.getStatus());
        response.setJobProgress(job.getProgressPercent());
        response.setErrorMessage(job.getErrorMessage());
    }

    private DataRestoreJob startRestoreJob(InputStream inputStream, boolean newSurvey, String expectedSurveyName, User user, boolean validateRecords, boolean deleteAllRecords, DataRestoreTask.OverwriteStrategy recordOverwriteStrategy) throws IOException, FileNotFoundException, ZipException {
        File tempFile = null;
        try {
            tempFile = this.createTempFile(inputStream);
            SurveyBackupInfo info = this.extractInfo(tempFile);
            CollectSurvey publishedSurvey = this.findPublishedSurvey(info);
            if (newSurvey) {
                this.checkPackagedNewSurveyValidity(info);
            } else {
                this.checkPackagedSurveyValidity(info, expectedSurveyName);
            }
            UserGroup newSurveyUserGroup = this.userGroupManager.getDefaultPublicUserGroup();
            DataRestoreJob job = (DataRestoreJob)this.jobManager.createJob("dataRestoreJob", DataRestoreJob.class);
            job.setUser(user);
            job.setStoreRestoredFile(true);
            job.setPublishedSurvey(publishedSurvey);
            job.setNewSurveyUserGroup(newSurveyUserGroup);
            job.setFile(tempFile);
            job.setRecordOverwriteStrategy(recordOverwriteStrategy);
            job.setRestoreUploadedFiles(true);
            job.setValidateRecords(validateRecords);
            job.setDeleteAllRecordsBeforeRestore(deleteAllRecords);
            job.addStatusChangeListener(event -> {
                if (event.getTo() == Worker.Status.COMPLETED) {
                    this.appWS.sendMessage(AppWS.MessageType.SURVEYS_UPDATED);
                }
            });
            String lockId = this.extractSurveyUri(tempFile);
            this.jobManager.start((Job)job, lockId);
            return job;
        }
        catch (Exception e) {
            FileUtils.deleteQuietly((File)tempFile);
            throw e;
        }
    }

    private void checkPackagedSurveyValidity(SurveyBackupInfo info, String expectedSurveyName) throws ZipException, FileNotFoundException, IOException {
        CollectSurvey publishedSurvey = this.findPublishedSurvey(info);
        if (publishedSurvey == null) {
            throw new IllegalArgumentException(String.format("Published survey not found (URI=\"%s\")", info.getSurveyUri()));
        }
    }

    private CollectSurvey findPublishedSurvey(SurveyBackupInfo info) throws ZipException, IOException {
        CollectSurvey survey = this.surveyManager.getByUri(info.getSurveyUri());
        return survey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SurveyBackupInfo extractInfo(File tempFile) throws ZipException, IOException {
        SurveyBackupInfo surveyBackupInfo;
        BackupFileExtractor backupFileExtractor = null;
        try {
            SurveyBackupInfo info;
            backupFileExtractor = new BackupFileExtractor(tempFile);
            surveyBackupInfo = info = backupFileExtractor.extractInfo();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(backupFileExtractor);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)backupFileExtractor);
        return surveyBackupInfo;
    }

    private void checkPackagedNewSurveyValidity(SurveyBackupInfo info) throws ZipException, IOException {
        CollectSurvey publishedSurvey = this.findPublishedSurvey(info);
        if (publishedSurvey != null) {
            throw new IllegalArgumentException("The backup file is associated to a survey with name " + publishedSurvey.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String extractSurveyUri(File tempFile) throws ZipException, IOException, FileNotFoundException {
        String string;
        BackupFileExtractor backupFileExtractor = null;
        try {
            String surveyUri;
            backupFileExtractor = new BackupFileExtractor(tempFile);
            File infoFile = backupFileExtractor.extractInfoFile();
            SurveyBackupInfo backupInfo = SurveyBackupInfo.parse((InputStream)new FileInputStream(infoFile));
            string = surveyUri = backupInfo.getSurveyUri();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(backupFileExtractor);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)backupFileExtractor);
        return string;
    }

    private File createTempFile(InputStream inputStream) throws IOException {
        File file = File.createTempFile("ofc_data_restore", ".collect-backup");
        file.deleteOnExit();
        FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)file);
        return file;
    }

    public static class RemoteDataRestoreResponse
    extends JobStatusResponse {
    }
}

