/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.io.metadata.codelist;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.openforis.collect.manager.CodeListManager;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.commons.io.csv.CsvWriter;
import org.openforis.concurrency.Task;
import org.openforis.idm.metamodel.CodeList;
import org.openforis.idm.metamodel.CodeListItem;
import org.openforis.idm.metamodel.CodeListLevel;

public class CodeListExportTask
extends Task {
    private static final String FLAT_LIST_LEVEL_NAME = "item";
    private static final char SEPARATOR = ',';
    private static final char QUOTECHAR = '\"';
    private CodeListManager codeListManager;
    private CodeList list;
    private OutputStream out;
    private CsvWriter writer;
    private Map<Integer, Boolean> qualifiableByLevel;

    protected void createInternalVariables() throws Throwable {
        super.createInternalVariables();
        this.qualifiableByLevel = this.codeListManager.hasQualifiableItemsByLevel(this.list);
        OutputStreamWriter osWriter = new OutputStreamWriter(this.out, "UTF-8");
        this.writer = new CsvWriter((Writer)osWriter, ',', '\"');
    }

    protected void execute() throws Throwable {
        this.initHeaders();
        List rootItems = this.codeListManager.loadRootItems(this.list);
        for (CodeListItem item : rootItems) {
            this.writeItem(item, Collections.emptyList());
        }
    }

    protected void onCompleted() {
        super.onCompleted();
        try {
            this.writer.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void initHeaders() {
        ArrayList<String> colNames = new ArrayList<String>();
        List levels = this.list.getHierarchy();
        ArrayList<String> levelNames = new ArrayList<String>();
        if (levels.isEmpty()) {
            levelNames.add(FLAT_LIST_LEVEL_NAME);
        } else {
            for (CodeListLevel level : levels) {
                String levelName = level.getName();
                levelNames.add(levelName);
            }
        }
        List langs = this.list.getSurvey().getLanguages();
        int levelIdx = 0;
        for (String levelName : levelNames) {
            colNames.add(levelName + "_code");
            for (String lang : langs) {
                colNames.add(levelName + "_label" + "_" + lang);
            }
            for (String lang : langs) {
                colNames.add(levelName + "_description" + "_" + lang);
            }
            if (this.qualifiableByLevel.get(levelIdx).booleanValue()) {
                colNames.add(levelName + "_qualifiable");
            }
            ++levelIdx;
        }
        this.writer.writeHeaders(colNames);
    }

    protected void writeItem(CodeListItem item, List<CodeListItem> ancestors) {
        ArrayList<String> lineValues = new ArrayList<String>();
        lineValues.addAll(this.extractAncestorsLineValues(ancestors));
        lineValues.addAll(this.extractItemLineValues(item));
        this.writer.writeNext(lineValues);
        List children = this.codeListManager.loadChildItems(item);
        ArrayList<CodeListItem> childAncestors = new ArrayList<CodeListItem>(ancestors);
        childAncestors.add(item);
        for (CodeListItem child : children) {
            this.writeItem(child, childAncestors);
        }
    }

    protected List<String> extractItemLineValues(CodeListItem item) {
        ArrayList<String> lineValues = new ArrayList<String>();
        lineValues.add(item.getCode());
        CollectSurvey survey = (CollectSurvey)item.getSurvey();
        List langs = survey.getLanguages();
        for (String lang : langs) {
            String label = item.getLabel(lang);
            lineValues.add(label);
        }
        for (String lang : langs) {
            String descr = item.getDescription(lang);
            lineValues.add(descr);
        }
        if (this.qualifiableByLevel.get(item.getLevel() - 1).booleanValue()) {
            lineValues.add(String.valueOf(item.isQualifiable()));
        }
        return lineValues;
    }

    protected List<String> extractAncestorsLineValues(List<CodeListItem> ancestors) {
        ArrayList<String> lineValues = new ArrayList<String>();
        for (CodeListItem item : ancestors) {
            lineValues.addAll(this.extractItemLineValues(item));
        }
        return lineValues;
    }

    public void setOut(OutputStream out) {
        this.out = out;
    }

    public CodeList getList() {
        return this.list;
    }

    public void setList(CodeList list) {
        this.list = list;
    }

    public void setCodeListManager(CodeListManager codeListManager) {
        this.codeListManager = codeListManager;
    }
}

