/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.manager.dataexport.codelist;

import java.io.Closeable;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.openforis.collect.manager.CodeListManager;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.commons.io.csv.CsvWriter;
import org.openforis.commons.io.excel.ExcelFlatValuesWriter;
import org.openforis.commons.io.flat.FlatDataWriter;
import org.openforis.idm.metamodel.CodeList;
import org.openforis.idm.metamodel.CodeListItem;
import org.openforis.idm.metamodel.CodeListLevel;

public class CodeListExportProcess {
    private static final String FLAT_LIST_LEVEL_NAME = "item";
    private static final char SEPARATOR = ',';
    private static final char QUOTECHAR = '\"';
    private CodeListManager codeListManager;

    public CodeListExportProcess(CodeListManager codeListManager) {
        this.codeListManager = codeListManager;
    }

    public void exportToCSV(OutputStream out, CollectSurvey survey, int codeListId) {
        this.export(out, survey, codeListId, OutputFormat.CSV);
    }

    public void export(OutputStream out, CollectSurvey survey, int codeListId, OutputFormat outputFormat) {
        CodeList list = survey.getCodeListById(codeListId);
        Map qualifiableByLevel = this.codeListManager.hasQualifiableItemsByLevel(list);
        ExcelFlatValuesWriter writer = null;
        try {
            if (outputFormat == OutputFormat.CSV) {
                OutputStreamWriter osWriter = new OutputStreamWriter(out, Charset.forName("UTF-8"));
                writer = new CsvWriter((Writer)osWriter, ',', '\"');
            } else {
                writer = new ExcelFlatValuesWriter(out);
            }
            this.initHeaders((FlatDataWriter)writer, survey, list, qualifiableByLevel);
            List rootItems = this.codeListManager.loadRootItems(list);
            for (CodeListItem item : rootItems) {
                List<CodeListItem> ancestors = Collections.emptyList();
                this.writeItem((FlatDataWriter)writer, qualifiableByLevel, item, ancestors);
            }
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(String.format("Error exporting code list %s: %s", list.getName(), e.getMessage()), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)writer);
    }

    private void initHeaders(FlatDataWriter writer, CollectSurvey survey, CodeList list, Map<Integer, Boolean> qualifiableByLevel) {
        ArrayList<String> colNames = new ArrayList<String>();
        List levels = list.getHierarchy();
        ArrayList<String> levelNames = new ArrayList<String>();
        if (levels.isEmpty()) {
            levelNames.add(FLAT_LIST_LEVEL_NAME);
        } else {
            for (CodeListLevel level : levels) {
                String levelName = level.getName();
                levelNames.add(levelName);
            }
        }
        int levelIdx = 0;
        for (String levelName : levelNames) {
            colNames.add(levelName + "_code");
            List langs = survey.getLanguages();
            for (String lang : langs) {
                colNames.add(levelName + "_label" + "_" + lang);
            }
            for (String lang : langs) {
                colNames.add(levelName + "_description" + "_" + lang);
            }
            if (qualifiableByLevel.get(levelIdx).booleanValue()) {
                colNames.add(levelName + "_qualifiable");
            }
            ++levelIdx;
        }
        writer.writeHeaders(colNames);
    }

    protected void writeItem(FlatDataWriter writer, Map<Integer, Boolean> qualifiableByLevel, CodeListItem item, List<CodeListItem> ancestors) {
        ArrayList<String> lineValues = new ArrayList<String>();
        lineValues.addAll(this.getAncestorsLineValues(qualifiableByLevel, ancestors));
        lineValues.addAll(this.getItemLineValues(qualifiableByLevel, item));
        writer.writeNext(lineValues);
        List children = this.codeListManager.loadChildItems(item);
        ArrayList<CodeListItem> childAncestors = new ArrayList<CodeListItem>(ancestors);
        childAncestors.add(item);
        for (CodeListItem child : children) {
            this.writeItem(writer, qualifiableByLevel, child, childAncestors);
        }
    }

    protected List<String> getItemLineValues(Map<Integer, Boolean> qualifiableByLevel, CodeListItem item) {
        String text;
        ArrayList<String> lineValues = new ArrayList<String>();
        lineValues.add(item.getCode());
        CollectSurvey survey = (CollectSurvey)item.getSurvey();
        List langs = survey.getLanguages();
        for (String lang : langs) {
            text = item.getLabel(lang);
            lineValues.add(text);
        }
        for (String lang : langs) {
            text = item.getDescription(lang);
            lineValues.add(text);
        }
        if (qualifiableByLevel.get(item.getLevel() - 1).booleanValue()) {
            lineValues.add(String.valueOf(item.isQualifiable()));
        }
        return lineValues;
    }

    protected List<String> getAncestorsLineValues(Map<Integer, Boolean> qualifiableByLevel, List<CodeListItem> ancestors) {
        ArrayList<String> lineValues = new ArrayList<String>();
        for (CodeListItem item : ancestors) {
            lineValues.addAll(this.getItemLineValues(qualifiableByLevel, item));
        }
        return lineValues;
    }

    public static enum OutputFormat {
        CSV,
        EXCEL;

    }
}

