/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.model.proxy;

import org.openforis.collect.Proxy;
import org.openforis.idm.model.TaxonOccurrence;
import org.openforis.idm.model.species.Taxon;

public class TaxonOccurrenceProxy
implements Proxy {
    private transient TaxonOccurrence occurrence;

    public TaxonOccurrenceProxy(TaxonOccurrence occurence) {
        this.occurrence = occurence;
    }

    public String getCode() {
        return this.occurrence.getCode();
    }

    public String getScientificName() {
        return this.occurrence.getScientificName();
    }

    public String getVernacularName() {
        return this.occurrence.getVernacularName();
    }

    public String getLanguageCode() {
        return this.occurrence.getLanguageCode();
    }

    public String getLanguageVariety() {
        return this.occurrence.getLanguageVariety();
    }

    public Taxon.TaxonRank getTaxonRank() {
        return this.occurrence.getTaxonRank();
    }

    public String getFamilyCode() {
        if (this.occurrence.getTaxonRank() == Taxon.TaxonRank.FAMILY) {
            return this.occurrence.getCode();
        }
        TaxonOccurrence familyTaxon = this.occurrence.getAncestorTaxon(Taxon.TaxonRank.FAMILY);
        return familyTaxon == null ? null : familyTaxon.getCode();
    }

    public String getFamilyScientificName() {
        if (this.occurrence.getTaxonRank() == Taxon.TaxonRank.FAMILY) {
            return this.occurrence.getScientificName();
        }
        TaxonOccurrence familyTaxon = this.occurrence.getAncestorTaxon(Taxon.TaxonRank.FAMILY);
        return familyTaxon == null ? null : familyTaxon.getScientificName();
    }
}

