/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.viewmodel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openforis.collect.designer.form.NodeDefinitionFormObject;
import org.openforis.collect.designer.metamodel.AttributeTypeUtils;
import org.openforis.collect.designer.metamodel.NodeType;
import org.openforis.collect.designer.util.MessageUtil;
import org.openforis.collect.designer.viewmodel.SurveyObjectBaseVM;
import org.openforis.collect.manager.validation.CollectEarthSurveyValidator;
import org.openforis.collect.metamodel.ui.UIOptions;
import org.openforis.collect.metamodel.ui.UITab;
import org.openforis.collect.metamodel.ui.UITabSet;
import org.openforis.collect.utils.SurveyObjects;
import org.openforis.idm.metamodel.AttributeDefinition;
import org.openforis.idm.metamodel.AttributeType;
import org.openforis.idm.metamodel.CodeAttributeDefinition;
import org.openforis.idm.metamodel.EntityDefinition;
import org.openforis.idm.metamodel.KeyAttributeDefinition;
import org.openforis.idm.metamodel.NodeDefinition;
import org.openforis.idm.metamodel.NodeLabel;
import org.zkoss.bind.BindUtils;
import org.zkoss.bind.Binder;
import org.zkoss.bind.Form;
import org.zkoss.bind.SimpleForm;
import org.zkoss.bind.annotation.BindingParam;
import org.zkoss.bind.annotation.Command;
import org.zkoss.bind.annotation.ContextParam;
import org.zkoss.bind.annotation.ContextType;
import org.zkoss.bind.annotation.DependsOn;
import org.zkoss.bind.annotation.GlobalCommand;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.IdSpace;
import org.zkoss.zk.ui.Path;

public abstract class NodeDefinitionVM<T extends NodeDefinition>
extends SurveyObjectBaseVM<T> {
    protected static final String FORM_CONTAINER_ID = "nodeFormContainer";
    private static final String NAME_FIELD_NAME = "name";
    private static final String INSTANCE_LABEL_FIELD_NAME = "instanceLabel";
    protected static final String MULTIPLE_FIELD_NAME = "multiple";
    protected SimpleForm tempFormObject;
    protected EntityDefinition parentEntity;

    public NodeDefinitionVM() {
        this.fieldLabelKeyPrefixes.addAll(Arrays.asList("survey.schema.node"));
    }

    protected void initInternal(EntityDefinition parentEntity, T nodeDefn, Boolean newItem) {
        super.init();
        this.tempFormObject = new SimpleForm();
        if (nodeDefn != null) {
            this.parentEntity = parentEntity;
            this.newItem = newItem;
            this.setEditedItem(nodeDefn);
        }
    }

    @Override
    protected T createItemInstance() {
        return null;
    }

    @Override
    protected void addNewItemToSurvey() {
    }

    @Override
    protected void moveSelectedItemInSurvey(int indexTo) {
    }

    @Override
    @GlobalCommand
    public void currentLanguageChanged() {
        super.currentLanguageChanged();
        this.setEditedItem((NodeDefinition)this.editedItem);
        this.notifyChange("tempFormObject", "formObject");
    }

    @Override
    public void commitChanges(@ContextParam(value=ContextType.BINDER) Binder binder) {
        this.formObject.saveTo((NodeDefinition)this.editedItem, this.currentLanguageCode);
        boolean editingRootEntity = this.parentEntity == null;
        boolean wasNewItem = this.newItem;
        if (wasNewItem) {
            if (!editingRootEntity) {
                this.schemaUpdater.addChildDefinition(this.parentEntity, (NodeDefinition)this.editedItem);
                this.validateForm(binder);
            }
            this.newItem = false;
        }
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("parentEntity", this.parentEntity);
        args.put("node", this.editedItem);
        args.put("newItem", wasNewItem);
        BindUtils.postGlobalCommand(null, null, (String)"editedNodeChanged", args);
        this.dispatchSurveyChangedCommand();
    }

    @Command
    public void nameChanged(@ContextParam(value=ContextType.BINDER) Binder binder, @BindingParam(value="name") String name) {
        name = SurveyObjects.adjustInternalName((String)name);
        this.setTempFormObjectFieldValue(NAME_FIELD_NAME, name);
        ((NodeDefinitionFormObject)this.formObject).setName(name);
        String singleInstanceLabel = (String)this.getTempFormObjectFieldValue(INSTANCE_LABEL_FIELD_NAME);
        if (StringUtils.isBlank((CharSequence)singleInstanceLabel) && StringUtils.isNotBlank((CharSequence)name)) {
            singleInstanceLabel = this.suggestLabel(name);
            this.setTempFormObjectFieldValue(INSTANCE_LABEL_FIELD_NAME, singleInstanceLabel);
            ((NodeDefinitionFormObject)this.formObject).setInstanceLabel(singleInstanceLabel);
        }
        this.dispatchApplyChangesCommand(binder);
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("item", this.editedItem);
        args.put(NAME_FIELD_NAME, name);
        BindUtils.postGlobalCommand(null, null, (String)"editedNodeNameChanging", args);
    }

    @Command
    public void singleInstanceLabelChange(@ContextParam(value=ContextType.BINDER) Binder binder, @BindingParam(value="label") String value) {
        this.dispatchApplyChangesCommand(binder);
        ((NodeDefinitionFormObject)this.formObject).setInstanceLabel(value);
        String name = (String)this.getTempFormObjectFieldValue(NAME_FIELD_NAME);
        if (StringUtils.isBlank((CharSequence)name) && StringUtils.isNotBlank((CharSequence)value)) {
            name = this.suggestInternalName(value);
            this.nameChanged(binder, name);
        }
    }

    @Command
    public void multipleChanged(@ContextParam(value=ContextType.BINDER) Binder binder, @BindingParam(value="multiple") Boolean multiple) {
        this.setTempFormObjectFieldValue(MULTIPLE_FIELD_NAME, multiple);
        this.dispatchApplyChangesCommand(binder);
    }

    protected String getInstanceLabel(NodeDefinition nodeDefn) {
        String label = nodeDefn.getLabel(NodeLabel.Type.INSTANCE, this.currentLanguageCode);
        return label;
    }

    @Override
    protected List<T> getItemsInternal() {
        return null;
    }

    @Override
    protected void deleteItemFromSurvey(T item) {
    }

    @GlobalCommand
    public void tabSetChanged(@ContextParam(value=ContextType.BINDER) Binder binder, @BindingParam(value="tabSet") UITabSet tabSet) {
        this.notifyChange("assignableTabNames");
        if (this.isEditingItem()) {
            this.validateForm(binder);
        }
    }

    @GlobalCommand
    public void tabChanged(@ContextParam(value=ContextType.BINDER) Binder binder, @BindingParam(value="tab") UITab tab) {
        this.notifyChange("assignableTabNames");
    }

    @GlobalCommand
    public void closeVersioningManagerPopUp(@ContextParam(value=ContextType.BINDER) Binder binder) {
        this.validateForm(binder);
    }

    @Override
    protected void validateForm(@ContextParam(value=ContextType.BINDER) Binder binder) {
        Component view = binder.getView();
        IdSpace currentIdSpace = view.getSpaceOwner();
        Component formComponent = Path.getComponent((IdSpace)currentIdSpace, (String)FORM_CONTAINER_ID);
        Binder formComponentBinder = (Binder)formComponent.getAttribute("binder");
        formComponentBinder.postCommand("applyChanges", null);
    }

    public Form getTempFormObject() {
        return this.tempFormObject;
    }

    protected <V> V getTempFormObjectFieldValue(String field) {
        return (V)this.getFormFieldValue(this.tempFormObject, field);
    }

    protected void setTempFormObjectFieldValue(String field, Object value) {
        this.setFormFieldValue(this.tempFormObject, field, value);
    }

    @DependsOn(value={"editedItem"})
    public String getNodeType() {
        if (this.editedItem == null) {
            return null;
        }
        NodeType type = NodeType.valueOf((NodeDefinition)this.editedItem);
        return type.name();
    }

    @DependsOn(value={"editedItem"})
    public String getAttributeType() {
        if (this.editedItem != null && this.editedItem instanceof AttributeDefinition) {
            AttributeType type = AttributeType.valueOf((AttributeDefinition)((AttributeDefinition)this.editedItem));
            return type.name();
        }
        return null;
    }

    @DependsOn(value={"editedItem"})
    public String getAttributeTypeLabel() {
        String type = this.getAttributeType();
        return this.getAttributeTypeLabel(type);
    }

    public String getAttributeTypeLabel(String typeValue) {
        return AttributeTypeUtils.getLabel(typeValue);
    }

    @DependsOn(value={"editedItem"})
    public boolean isRootEntity() {
        return this.editedItem != null && this.parentEntity == null;
    }

    @DependsOn(value={"editedItem"})
    public boolean isParentEntityRoot() {
        return this.editedItem != null && this.parentEntity != null && (this.parentEntity.isRoot() || !this.parentEntity.isMultiple() && this.parentEntity.getNearestAncestorMultipleEntity().isRoot());
    }

    @DependsOn(value={"editedItem"})
    public boolean isAttribute() {
        return this.editedItem != null && this.editedItem instanceof AttributeDefinition;
    }

    @DependsOn(value={"editedItem"})
    public boolean isCodeAttribute() {
        return this.editedItem != null && this.editedItem instanceof CodeAttributeDefinition;
    }

    @DependsOn(value={"editedItem"})
    public boolean isKeyAllowed() {
        return this.editedItem != null && this.editedItem instanceof KeyAttributeDefinition;
    }

    @DependsOn(value={"editedItem"})
    public boolean isInsideTableEntity() {
        UIOptions uiOptions = this.getSurvey().getUIOptions();
        return this.editedItem != null && this.parentEntity != null && this.parentEntity.isMultiple() && uiOptions.getLayout(this.parentEntity) == UIOptions.Layout.TABLE;
    }

    @DependsOn(value={"editedItem"})
    public boolean isMultipleFieldEditingDisabled() {
        return false;
    }

    public boolean isRequiredApplied() {
        return true;
    }

    public List<Map<String, String>> getDependentNodes() {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        try {
            result.addAll(this.getDependentNodeInfos("relevancy", ((NodeDefinition)this.editedItem).getRelevancyDependentDefinitions()));
            result.addAll(this.getDependentNodeInfos("min_count", ((NodeDefinition)this.editedItem).getMinCountDependentDefinitions()));
            result.addAll(this.getDependentNodeInfos("max_count", ((NodeDefinition)this.editedItem).getMaxCountDependentDefinitions()));
            result.addAll(this.getDependentNodeInfos("calculated_value", ((NodeDefinition)this.editedItem).getCalculatedValueDependentDefinitions()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public boolean isPredefinedCollectEarthAttribute() {
        return this.editedItem != null && !this.newItem && ((NodeDefinition)this.editedItem).getParentEntityDefinition() != null && ((NodeDefinition)this.editedItem).getParentEntityDefinition().isRoot() && CollectEarthSurveyValidator.REQUIRED_FIELD_NAMES.contains(((NodeDefinition)this.editedItem).getName());
    }

    protected List<Map<String, String>> getDependentNodeInfos(String type, List<NodeDefinition> nodes) {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        for (NodeDefinition node : nodes) {
            HashMap<String, String> nodeInfo = new HashMap<String, String>();
            nodeInfo.put("type", type);
            nodeInfo.put("path", node.getPath());
            if (result.contains(nodeInfo)) continue;
            result.add(nodeInfo);
        }
        return result;
    }

    protected boolean checkNodeAttached() {
        if (this.editedItem == null || ((NodeDefinition)this.editedItem).getParentDefinition() == null) {
            MessageUtil.showWarning("survey.schema.node.error.node_not_yet_attached", new Object[0]);
            return false;
        }
        return true;
    }
}

