/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.openforis.collect.utils.Files;

public abstract class Controllers {
    public static void writeFileToResponse(HttpServletResponse response, File file) throws IOException {
        Controllers.writeFileToResponse(response, file, file.getName());
    }

    public static void writeFileToResponse(HttpServletResponse response, File file, String outputFileName) throws FileNotFoundException, IOException {
        String contentType = Files.getContentType((String)outputFileName);
        Controllers.writeFileToResponse(response, file, outputFileName, contentType);
    }

    public static void writeFileToResponse(HttpServletResponse response, File file, String outputFileName, String contentType) throws FileNotFoundException, IOException {
        Controllers.writeFileToResponse(response, new FileInputStream(file), outputFileName, contentType, file.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFileToResponse(HttpServletResponse response, InputStream is, String outputFileName, String contentType, long fileSize) throws IOException {
        ServletOutputStream os = response.getOutputStream();
        try {
            Controllers.setOutputContent(response, outputFileName, contentType, fileSize);
            IOUtils.copy((InputStream)is, (OutputStream)os);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
            os.flush();
        }
    }

    public static void setOutputContent(HttpServletResponse response, String outputFileName, String contentType) {
        Controllers.setOutputContent(response, outputFileName, contentType, null);
    }

    public static void setOutputContent(HttpServletResponse response, String outputFileName, String contentType, Long contentLength) {
        response.setContentType(contentType);
        response.setHeader("Content-Disposition", "attachment; filename=\"" + outputFileName + "\"");
        if (contentLength != null) {
            if (contentLength <= Integer.MAX_VALUE) {
                response.setContentLength(contentLength.intValue());
            } else {
                response.setHeader("Content-length", contentLength.toString());
            }
        }
    }
}

