/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.web.controller;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.openforis.collect.concurrency.CollectJobManager;
import org.openforis.collect.manager.RecordManager;
import org.openforis.collect.manager.SurveyManager;
import org.openforis.collect.metamodel.CollectAnnotations;
import org.openforis.collect.model.CollectRecord;
import org.openforis.collect.model.CollectRecordSummary;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.model.NodeProcessor;
import org.openforis.collect.model.RecordCoordinatesKmlGeneratorJob;
import org.openforis.collect.model.RecordFilter;
import org.openforis.concurrency.Job;
import org.openforis.idm.geospatial.CoordinateOperations;
import org.openforis.idm.metamodel.AttributeDefinition;
import org.openforis.idm.metamodel.CoordinateAttributeDefinition;
import org.openforis.idm.metamodel.NodeDefinition;
import org.openforis.idm.metamodel.validation.DistanceCheck;
import org.openforis.idm.model.AbstractValue;
import org.openforis.idm.model.Attribute;
import org.openforis.idm.model.Coordinate;
import org.openforis.idm.model.CoordinateAttribute;
import org.openforis.idm.model.Node;
import org.openforis.idm.model.NodeVisitor;
import org.openforis.idm.model.TextAttribute;
import org.openforis.idm.model.TextValue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"api"})
@Scope(value="session")
public class GeoDataController {
    @Autowired
    private SurveyManager surveyManager;
    @Autowired
    private RecordManager recordManager;
    @Autowired
    private CollectJobManager jobManager;
    @Autowired
    private CoordinateOperations coordinateOperations;

    @RequestMapping(value={"geo/coordinate/convert.json"}, method={RequestMethod.GET})
    @ResponseBody
    public Coordinate convertCoordinateTo(@RequestParam double x, @RequestParam double y, @RequestParam String srs, @RequestParam String srsIdTo) {
        Coordinate coordinate = new Coordinate(Double.valueOf(x), Double.valueOf(y), srs);
        return this.coordinateOperations.convertTo(coordinate, srsIdTo);
    }

    @RequestMapping(value={"survey/{surveyId}/data/coordinatevalues.json"}, method={RequestMethod.GET})
    @ResponseBody
    public List<CoordinateAttributePoint> loadCoordinateValues(@PathVariable int surveyId, @RequestParam int coordinateAttributeId, @RequestParam String srsId, @RequestParam int recordOffset, @RequestParam int maxNumberOfRecords) throws Exception {
        final ArrayList<CoordinateAttributePoint> result = new ArrayList<CoordinateAttributePoint>();
        CollectSurvey survey = this.surveyManager.loadSurvey(surveyId);
        this.extractAllRecordCoordinates(survey, recordOffset, maxNumberOfRecords, coordinateAttributeId, srsId, new CoordinateProcessor(){

            @Override
            public void process(CollectRecord record, CoordinateAttribute coordAttr, Coordinate coordinate) {
                CoordinateAttributePoint point = new CoordinateAttributePoint(coordAttr, coordinate);
                result.add(point);
            }
        });
        return result;
    }

    @RequestMapping(value={"survey/{surveyId}/data/geometries.json"}, method={RequestMethod.GET})
    @ResponseBody
    public List<GeometryNodeInfo> loadGeometryValues(@PathVariable int surveyId, @RequestParam int attributeId, @RequestParam String srsId, @RequestParam int recordOffset, @RequestParam int maxNumberOfRecords) throws Exception {
        final ArrayList<GeometryNodeInfo> result = new ArrayList<GeometryNodeInfo>();
        CollectSurvey survey = this.surveyManager.loadSurvey(surveyId);
        this.processNodes(survey, recordOffset, maxNumberOfRecords, attributeId, new NodeProcessor(){

            @Override
            public void process(Node<?> node) throws Exception {
                if (!node.isEmpty()) {
                    result.add(new GeometryNodeInfo((TextAttribute)node));
                }
            }
        });
        return result;
    }

    @RequestMapping(value={"survey/{surveyId}/data/coordinatesvalues.kml"}, method={RequestMethod.GET}, produces={"application/vnd.google-earth.kml+xml"})
    public void createCoordinateValuesKML(@PathVariable(value="surveyId") int surveyId, @RequestParam int stepNum, @RequestParam int coordinateAttributeId, HttpServletResponse response) throws Exception {
        CollectSurvey survey = this.surveyManager.getById(surveyId);
        CoordinateAttributeDefinition nodeDef = (CoordinateAttributeDefinition)survey.getSchema().getDefinitionById(coordinateAttributeId);
        RecordCoordinatesKmlGeneratorJob job = new RecordCoordinatesKmlGeneratorJob();
        job.setRecordManager(this.recordManager);
        RecordFilter filter = new RecordFilter(survey);
        job.setRecordFilter(filter);
        job.setNodeDefinition(nodeDef);
        job.setOutput((OutputStream)response.getOutputStream());
        CoordinateOperations coordinateOperations = survey.getContext().getCoordinateOperations();
        coordinateOperations.registerSRS(survey.getSpatialReferenceSystems());
        job.setCoordinateOperations(coordinateOperations);
        this.jobManager.start((Job)job, false);
    }

    private void extractAllRecordCoordinates(final CollectSurvey survey, Integer recordOffset, Integer maxNumberOfRecords, int coordinateAttributeId, final String toSrsId, final CoordinateProcessor coordinateProcessor) throws Exception {
        this.processNodes(survey, recordOffset, maxNumberOfRecords, coordinateAttributeId, new NodeProcessor(){

            @Override
            public void process(Node<?> node) throws Exception {
                CoordinateAttribute coordAttr = (CoordinateAttribute)node;
                if (coordAttr.isFilled()) {
                    Coordinate coordinate = coordAttr.getValue();
                    CoordinateOperations coordinateOperations = survey.getContext().getCoordinateOperations();
                    Coordinate projectedCoord = coordinateOperations.convertTo(coordinate, toSrsId);
                    coordinateProcessor.process((CollectRecord)node.getRecord(), coordAttr, projectedCoord);
                }
            }
        });
    }

    private void processNodes(CollectSurvey survey, Integer recordOffset, Integer maxNumberOfRecords, int attributeId, NodeProcessor nodeProcessor) throws Exception {
        NodeDefinition nodeDef = survey.getSchema().getDefinitionById(attributeId);
        RecordFilter filter = new RecordFilter(survey);
        filter.setOffset(recordOffset);
        filter.setMaxNumberOfRecords(maxNumberOfRecords);
        List summaries = this.recordManager.loadSummaries(filter);
        for (CollectRecordSummary summary : summaries) {
            CollectRecord record = this.recordManager.load(survey, summary.getId().intValue(), summary.getStep(), false);
            List nodes = record.findNodesByPath(nodeDef.getPath());
            for (Node node : nodes) {
                nodeProcessor.process(node);
            }
        }
    }

    private static interface CoordinateProcessor {
        public void process(CollectRecord var1, CoordinateAttribute var2, Coordinate var3);
    }

    public static class CoordinateAttributePoint
    extends NodeInfo<CoordinateAttribute> {
        private Coordinate coordinate;

        public CoordinateAttributePoint(CoordinateAttribute attribute, Coordinate coordinate) {
            super(attribute);
            this.coordinate = coordinate;
        }

        public Coordinate getOriginalCoordinate() {
            return ((CoordinateAttribute)this.node).getValue();
        }

        public Double getX() {
            return this.coordinate == null ? null : this.coordinate.getX();
        }

        public Double getY() {
            return this.coordinate == null ? null : this.coordinate.getY();
        }

        public Double getDistance() {
            CoordinateAttributeDefinition def = (CoordinateAttributeDefinition)((CoordinateAttribute)this.node).getDefinition();
            DistanceCheck distanceCheck = def.extractMaxDistanceCheck();
            if (distanceCheck == null) {
                return null;
            }
            return distanceCheck.evaluateDistanceToDestination((CoordinateAttribute)this.node);
        }
    }

    public static class GeometryNodeInfo
    extends NodeInfo<TextAttribute> {
        public GeometryNodeInfo(TextAttribute node) {
            super(node);
        }

        public String getGeometry() {
            TextValue value = ((TextAttribute)this.node).getValue();
            return value.getValue();
        }
    }

    public static class RecordDataItem {
        private int definitionId;
        private String value;

        public RecordDataItem(int definitionId, String value) {
            this.definitionId = definitionId;
            this.value = value;
        }

        public int getDefinitionId() {
            return this.definitionId;
        }

        public void setDefinitionId(int definitionId) {
            this.definitionId = definitionId;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static abstract class NodeInfo<T extends Node<?>> {
        protected T node;

        public NodeInfo(T node) {
            this.node = node;
        }

        public int getRecId() {
            return this.node.getRecord().getId();
        }

        public CollectRecord.Step getRecStep() {
            return ((CollectRecord)this.node.getRecord()).getStep();
        }

        public List<String> getRecKeys() {
            CollectRecord record = (CollectRecord)this.node.getRecord();
            return record.getRootEntityKeyValues();
        }

        public List<RecordDataItem> getRecordData() {
            final ArrayList<RecordDataItem> result = new ArrayList<RecordDataItem>();
            CollectSurvey survey = (CollectSurvey)this.node.getSurvey();
            final CollectAnnotations annotations = survey.getAnnotations();
            this.node.getRecord().getRootEntity().visitChildren(new NodeVisitor(){

                public void visit(Node<? extends NodeDefinition> node, int idx) {
                    if (node instanceof Attribute && annotations.isShowInMapBalloon((AttributeDefinition)node.getDefinition())) {
                        Attribute attr = (Attribute)node;
                        AbstractValue val = (AbstractValue)attr.getValue();
                        String value = val.toPrettyFormatString();
                        result.add(new RecordDataItem(node.getDefinition().getId(), value));
                    }
                }
            }, true);
            return result;
        }

        public int getAttrId() {
            return this.node.getInternalId();
        }

        public int getAttrDefId() {
            return this.node.getDefinition().getId();
        }
    }
}

