/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.viewmodel;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openforis.collect.designer.form.AttributeFormObject;
import org.openforis.collect.designer.util.MessageUtil;
import org.openforis.idm.metamodel.ReferenceDataSchema;
import org.zkoss.zul.ListModelList;

class ReferenceDataAttributesEditor {
    private static final String ERROR_ATTRIBUTE_NAME_REQUIRED = "global.validation.name_required";
    private static final String ERROR_ATTRIBUTE_NAME_INVALID = "global.validation.internal_name.invalid_value";
    private static final String ERROR_ATTRIBUTE_NAME_DUPLICATE = "global.item.validation.name_already_defined";
    private ReferenceDataSchema.ReferenceDataDefinition referenceDataDefinition;
    private List<String> fixedColumnNames;
    private ListModelList<AttributeFormObject> attributes;

    public ReferenceDataAttributesEditor(List<String> fixedColumnNames, ReferenceDataSchema.ReferenceDataDefinition referenceDataDefinition) {
        this.fixedColumnNames = fixedColumnNames;
        this.referenceDataDefinition = referenceDataDefinition;
    }

    public List<AttributeFormObject> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new ListModelList();
            for (String colName : this.fixedColumnNames) {
                this.attributes.add((Object)new AttributeFormObject(false, this.attributes.size(), colName));
            }
            List infoAttributeNames = this.referenceDataDefinition.getAttributeNames();
            for (String infoAttributeName : infoAttributeNames) {
                this.attributes.add((Object)new AttributeFormObject(true, this.attributes.size(), infoAttributeName));
            }
        }
        return this.attributes;
    }

    public void changeAttributeEditableStatus(AttributeFormObject attribute) {
        attribute.setEditingStatus(!attribute.getEditingStatus());
        this.refreshAttributeColumnTemplate(attribute);
    }

    private void refreshAttributeColumnTemplate(AttributeFormObject attribute) {
        int index = this.attributes.indexOf((Object)attribute);
        this.attributes.set(index, (Object)attribute);
    }

    public boolean confirmAttributeUpdate(AttributeFormObject attribute) {
        int infoAttributeIndex = attribute.getIndex() - this.fixedColumnNames.size();
        ReferenceDataSchema.ReferenceDataDefinition.Attribute oldAttribute = (ReferenceDataSchema.ReferenceDataDefinition.Attribute)this.referenceDataDefinition.getAttributes().get(infoAttributeIndex);
        if (oldAttribute.getName().equals(attribute.getName())) {
            this.changeAttributeEditableStatus(attribute);
            return false;
        }
        if (this.validateAttribute(attribute)) {
            this.changeAttributeEditableStatus(attribute);
            this.referenceDataDefinition.setAttribute(infoAttributeIndex, new ReferenceDataSchema.ReferenceDataDefinition.Attribute(attribute.getName()));
            return true;
        }
        return false;
    }

    private boolean validateAttribute(AttributeFormObject attribute) {
        String name = attribute.getName();
        String error = null;
        if (StringUtils.isBlank((CharSequence)name)) {
            error = ERROR_ATTRIBUTE_NAME_REQUIRED;
        } else if (!name.matches("[a-z][a-z0-9_]*")) {
            error = ERROR_ATTRIBUTE_NAME_INVALID;
        } else {
            for (int index = 0; index < this.attributes.size(); ++index) {
                AttributeFormObject attributeFormObject = (AttributeFormObject)this.attributes.get(index);
                if (!name.equals(attributeFormObject.getName()) || attribute.getIndex() == index) continue;
                error = ERROR_ATTRIBUTE_NAME_DUPLICATE;
                break;
            }
        }
        if (error == null) {
            return true;
        }
        MessageUtil.showError(error, new Object[0]);
        return false;
    }
}

