/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.web.controller;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.coobird.thumbnailator.Thumbnails;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.openforis.collect.manager.SessionRecordFileManager;
import org.openforis.collect.manager.SurveyManager;
import org.openforis.collect.metamodel.CollectAnnotations;
import org.openforis.collect.model.CollectRecord;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.utils.Controllers;
import org.openforis.collect.utils.Files;
import org.openforis.collect.web.controller.BasicController;
import org.openforis.collect.web.manager.SessionRecordProvider;
import org.openforis.idm.metamodel.FileAttributeDefinition;
import org.openforis.idm.model.FileAttribute;
import org.openforis.idm.model.Node;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@Scope(value="session")
@RequestMapping(value={"api"})
public class RecordFileController
extends BasicController
implements Serializable {
    private static final int THUMBNAIL_SIZE = 150;
    private static final long serialVersionUID = 1L;
    @Autowired
    private SurveyManager surveyManager;
    @Autowired
    private SessionRecordFileManager sessionRecordFileManager;
    @Autowired
    private SessionRecordProvider recordProvider;

    @RequestMapping(value={"/survey/{surveyId}/data/records/{recordId}/{recordStep}/file"}, method={RequestMethod.GET})
    public void downloadFile(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="surveyId") int surveyId, @PathVariable(value="recordId") int recordId, @PathVariable(value="recordStep") CollectRecord.Step recordStep, @RequestParam(value="nodePath") String nodePath) throws IOException {
        CollectSurvey survey = this.surveyManager.getOrLoadSurveyById(surveyId);
        CollectRecord record = this.recordProvider.provide(survey, recordId == 0 ? null : Integer.valueOf(recordId), recordStep);
        FileAttribute fileAttribute = (FileAttribute)record.getNodeByPath(nodePath);
        File file = this.getFile(fileAttribute);
        String outputFileName = this.determineOutputFileName(survey, fileAttribute, file);
        Controllers.writeFileToResponse(response, file, outputFileName);
    }

    @RequestMapping(value={"/survey/{surveyId}/data/records/{recordId}/{recordStep}/file-thumbnail"}, method={RequestMethod.GET})
    public void downloadThumbnail(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="surveyId") int surveyId, @PathVariable(value="recordId") int recordId, @PathVariable(value="recordStep") CollectRecord.Step recordStep, @RequestParam(value="nodePath") String nodePath) throws IOException {
        CollectSurvey survey = this.surveyManager.getOrLoadSurveyById(surveyId);
        CollectRecord record = this.recordProvider.provide(survey, recordId == 0 ? null : Integer.valueOf(recordId), recordStep);
        FileAttribute node = (FileAttribute)record.getNodeByPath(nodePath);
        File file = this.getFile(node);
        try {
            String extension = FilenameUtils.getExtension((String)file.getName());
            String outputFileName = String.format("node-%d-file-thumbnail.%s", node.getId(), extension);
            String contentType = Files.getContentType((String)outputFileName);
            response.setContentType(contentType);
            Thumbnails.of((File[])new File[]{file}).size(150, 150).toOutputStream((OutputStream)response.getOutputStream());
            return;
        }
        catch (Exception e) {
            Controllers.writeFileToResponse(response, file);
            return;
        }
    }

    private File getFile(FileAttribute node) {
        File file = this.sessionRecordFileManager.getFile(node);
        if (file == null || !file.exists()) {
            throw new IllegalStateException(String.format("File not found for attribute %s in record %d in survey %d", node.getPath(), node.getRecord().getId(), node.getSurvey().getId()));
        }
        return file;
    }

    private String determineOutputFileName(CollectSurvey survey, FileAttribute node, File file) {
        String originalFileName = file.getName();
        CollectAnnotations annotations = survey.getAnnotations();
        String fileNameExpression = annotations.getFileNameExpression((FileAttributeDefinition)node.getDefinition());
        if (StringUtils.isBlank((CharSequence)fileNameExpression)) {
            return originalFileName;
        }
        try {
            String fileName = (String)survey.getContext().getExpressionEvaluator().evaluateValue((Node)node.getParent(), (Node)node, fileNameExpression);
            String extension = FilenameUtils.getExtension((String)originalFileName);
            if (StringUtils.isBlank((CharSequence)extension)) {
                return fileName;
            }
            return fileName + "." + extension;
        }
        catch (Exception e) {
            return originalFileName;
        }
    }
}

