/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.viewmodel;

import java.io.File;
import java.util.HashMap;
import org.apache.commons.io.FilenameUtils;
import org.openforis.collect.designer.util.MessageUtil;
import org.openforis.collect.designer.util.Resources;
import org.openforis.collect.designer.viewmodel.JobStatusPopUpVM;
import org.openforis.collect.designer.viewmodel.SurveyBaseVM;
import org.openforis.collect.io.metadata.collectearth.RandomGridGenerationJob;
import org.openforis.collect.manager.SurveyManager;
import org.openforis.collect.model.SurveyFile;
import org.openforis.collect.utils.Files;
import org.openforis.concurrency.Job;
import org.openforis.idm.metamodel.AttributeDefinition;
import org.zkoss.bind.BindUtils;
import org.zkoss.bind.Binder;
import org.zkoss.bind.annotation.Command;
import org.zkoss.bind.annotation.ContextParam;
import org.zkoss.bind.annotation.ContextType;
import org.zkoss.bind.annotation.ExecutionArgParam;
import org.zkoss.bind.annotation.Init;
import org.zkoss.zk.ui.select.annotation.WireVariable;
import org.zkoss.zul.Window;

public class SurveyFileRandomGridGenerationParametersPopUpVM
extends SurveyBaseVM {
    private static final String SURVEY_FILE_RANDOM_GRID_GENERATION_COMPLETE_GLOBAL_COMMAND = "surveyFileRandomGridGenerationComplete";
    private static final String CLOSE_SURVEY_FILE_RANDOM_GRID_GENERATION_GLOBAL_COMMAND = "closeRandomGridGenerationPopUp";
    @WireVariable
    private SurveyManager surveyManager;
    private SurveyFile sourceGridFile;
    private RandomGridGenerationParametersForm form = new RandomGridGenerationParametersForm();
    private Window jobStatusPopUp;

    public static Window openPopUp(SurveyFile sourceGridFile) {
        HashMap<String, SurveyFile> args = new HashMap<String, SurveyFile>();
        args.put("sourceGridFile", sourceGridFile);
        return SurveyFileRandomGridGenerationParametersPopUpVM.openPopUp(Resources.Component.SURVEY_FILE_RANDOM_GRID_GENERATION_PARAMETERS_POPUP.getLocation(), true, args);
    }

    @Init(superclass=false)
    public void init(@ExecutionArgParam(value="sourceGridFile") SurveyFile sourceGridFile) {
        super.init();
        this.sourceGridFile = sourceGridFile;
    }

    @Command
    public void applyChanges() {
    }

    @Command
    public void close() {
        BindUtils.postGlobalCommand(null, null, (String)CLOSE_SURVEY_FILE_RANDOM_GRID_GENERATION_GLOBAL_COMMAND, null);
    }

    @Command
    public void start(@ContextParam(value=ContextType.BINDER) Binder binder) {
        try {
            AttributeDefinition measurementKeyDef = this.survey.getFirstMeasurementKeyDef();
            String measurementAttrName = measurementKeyDef.getName();
            Double percentage = this.form.getPercentage();
            String nextMeasurement = this.form.getNextMeasurement();
            final String outputSurveyFileName = FilenameUtils.getBaseName((String)this.sourceGridFile.getFilename()) + "_" + measurementAttrName + "_" + nextMeasurement + ".csv";
            RandomGridGenerationJob job = (RandomGridGenerationJob)this.jobManager.createJob(RandomGridGenerationJob.class);
            job.setSurvey(this.survey);
            byte[] fileContent = this.surveyManager.loadSurveyFileContent(this.sourceGridFile);
            File file = Files.witeToTempFile((byte[])fileContent, (String)"source_grid", (String)".csv");
            job.setSurveyManager(this.surveyManager);
            job.setFile(file);
            job.setSurveyFileName(outputSurveyFileName);
            job.setPercentage(percentage);
            job.setNewMeasurement(nextMeasurement);
            this.jobManager.start((Job)job);
            this.jobStatusPopUp = JobStatusPopUpVM.openPopUp("survey.file.random_grid_generation.title", job, true, new JobStatusPopUpVM.JobEndHandler<RandomGridGenerationJob>(){

                @Override
                public void onJobEnd(RandomGridGenerationJob job) {
                    SurveyFileRandomGridGenerationParametersPopUpVM.this.closeJobStatusPopUp();
                    switch (job.getStatus()) {
                        case COMPLETED: {
                            MessageUtil.showInfo("survey.file.random_grid_generation.complete_successfully", outputSurveyFileName);
                            HashMap<String, String> args = new HashMap<String, String>();
                            args.put("outputSurveyFileName", outputSurveyFileName);
                            BindUtils.postGlobalCommand(null, null, (String)SurveyFileRandomGridGenerationParametersPopUpVM.SURVEY_FILE_RANDOM_GRID_GENERATION_COMPLETE_GLOBAL_COMMAND, args);
                            break;
                        }
                        case FAILED: {
                            MessageUtil.showError("survey.file.random_grid_generation.error", job.getErrorMessage());
                            break;
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            MessageUtil.showError("survey.file.random_grid_generation.error", e.getMessage());
        }
    }

    private void closeJobStatusPopUp() {
        SurveyFileRandomGridGenerationParametersPopUpVM.closePopUp(this.jobStatusPopUp);
    }

    public RandomGridGenerationParametersForm getForm() {
        return this.form;
    }

    public void setForm(RandomGridGenerationParametersForm form) {
        this.form = form;
    }

    public static class RandomGridGenerationParametersForm {
        private Double percentage;
        private String nextMeasurement;

        public Double getPercentage() {
            return this.percentage;
        }

        public void setPercentage(Double percentage) {
            this.percentage = percentage;
        }

        public String getNextMeasurement() {
            return this.nextMeasurement;
        }

        public void setNextMeasurement(String nextMeasurement) {
            this.nextMeasurement = nextMeasurement;
        }
    }
}

