/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.concurrency;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.openforis.concurrency.JobManager;
import org.openforis.concurrency.Worker;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class Job
extends Worker {
    @Autowired
    private transient JobManager jobManager;
    private List<Worker> tasks = new ArrayList<Worker>();
    private int currentTaskIndex = -1;

    protected Job() {
    }

    @Override
    protected void initializeInternalVariables() throws Throwable {
        super.initializeInternalVariables();
        this.buildTasks();
    }

    @Override
    public int getProgressPercent() {
        switch (this.getStatus()) {
            case COMPLETED: {
                return 100;
            }
            case PENDING: {
                return 0;
            }
        }
        Worker currentTask = this.getCurrentTask();
        if (currentTask == null) {
            return 0;
        }
        int currentTaskProgress = currentTask == null ? 0 : currentTask.getProgressPercent();
        double tasksNum = Integer.valueOf(this.tasks.size()).doubleValue();
        double result = (100.0 * (double)this.currentTaskIndex + (double)currentTaskProgress) / tasksNum;
        return Double.valueOf(Math.floor(result)).intValue();
    }

    @Override
    public void abort() {
        super.abort();
        Worker currentTask = this.getCurrentTask();
        if (currentTask != null) {
            currentTask.abort();
        }
    }

    @Override
    protected void execute() throws Throwable {
        while (this.hasTaskToRun()) {
            Worker task = this.nextTask();
            this.initializeTask(task);
            switch (task.getStatus()) {
                case PENDING: {
                    this.runTask(task);
                    break;
                }
                case FAILED: {
                    this.onTaskFailed(task);
                    break;
                }
                case ABORTED: {
                    this.abort();
                    break;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void runTask(Worker task) throws Throwable {
        try {
            task.run();
            switch (task.getStatus()) {
                case COMPLETED: {
                    this.onTaskCompleted(task);
                    return;
                }
                case FAILED: {
                    this.onTaskFailed(task);
                    return;
                }
                case ABORTED: {
                    this.abort();
                    return;
                }
            }
            return;
        }
        finally {
            this.onTaskEnd(task);
        }
    }

    protected abstract void buildTasks() throws Throwable;

    protected <T extends Worker> T createTask(Class<T> type) {
        T task = this.jobManager.createWorker(type);
        return task;
    }

    protected boolean hasTaskToRun() {
        return this.isRunning() && this.currentTaskIndex + 1 < this.tasks.size();
    }

    protected Worker nextTask() {
        ++this.currentTaskIndex;
        return this.tasks.get(this.currentTaskIndex);
    }

    protected <T extends Worker> T addTask(Class<T> type) {
        T task = this.createTask(type);
        this.addTask(task);
        return task;
    }

    protected <T extends Worker> void addTask(T task) {
        if (!this.isPending()) {
            throw new IllegalStateException("Cannot add tasks to a job once started");
        }
        this.tasks.add(task);
    }

    protected <C extends Collection<? extends Worker>> void addTasks(C tasks) {
        for (Worker task : tasks) {
            this.addTask(task);
        }
    }

    protected void onTaskEnd(Worker task) {
    }

    protected void onTaskCompleted(Worker task) {
    }

    protected void onTaskFailed(Worker task) throws Throwable {
        if (task.getLastException() != null) {
            throw task.getLastException();
        }
        this.setErrorMessage(task.getErrorMessage());
        this.changeStatus(Worker.Status.FAILED);
    }

    protected void initializeTask(Worker task) {
        task.initialize();
    }

    public List<Worker> getTasks() {
        return Collections.unmodifiableList(this.tasks);
    }

    public int getCurrentTaskIndex() {
        return this.currentTaskIndex;
    }

    public Worker getCurrentTask() {
        return this.currentTaskIndex >= 0 ? this.tasks.get(this.currentTaskIndex) : null;
    }

    public JobManager getJobManager() {
        return this.jobManager;
    }

    public void setJobManager(JobManager jobManager) {
        this.jobManager = jobManager;
    }
}

