/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.concurrency;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.openforis.concurrency.Job;
import org.openforis.concurrency.JobManager;
import org.openforis.concurrency.Worker;

public class SimpleJobManager
implements JobManager {
    protected static final long MAX_JOB_IDLE_MILLIS = 1800000L;
    private static final long JOB_INFO_UPDATE_PERIOD_MILLIS = 60000L;
    private Map<String, Job> jobByLockId = new HashMap<String, Job>();
    private Map<String, JobInfo> jobInfoById = new HashMap<String, JobInfo>();
    private Executor jobExecutor = Executors.newCachedThreadPool();
    private Timer jobInfoUpdateTimer;

    public SimpleJobManager() {
        this.initJobInfoUpdateTimer();
    }

    public synchronized void destroy() {
        this.jobInfoUpdateTimer.cancel();
        this.abortRunningJobs();
    }

    private void abortRunningJobs() {
        Collection<Job> jobs = this.jobByLockId.values();
        for (Job job : jobs) {
            if (!job.isRunning()) continue;
            job.abort();
        }
    }

    private void initJobInfoUpdateTimer() {
        this.jobInfoUpdateTimer = new Timer();
        this.jobInfoUpdateTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                SimpleJobManager.this.pruneIdleJobs();
            }
        }, 60000L, 60000L);
    }

    @Override
    public <J extends Job> J createJob(Class<J> type) {
        return (J)((Job)this.createWorker(type));
    }

    @Override
    public <T extends Worker> T createWorker(Class<T> type) {
        try {
            T task = this.createInstance(type);
            if (task instanceof Job) {
                ((Job)task).setJobManager(this);
            }
            return task;
        }
        catch (Exception e) {
            throw new RuntimeException("Error instanciating worker of type " + type.getName(), e);
        }
    }

    protected <T extends Worker> T createInstance(Class<T> type) throws InstantiationException, IllegalAccessException {
        return (T)((Worker)type.newInstance());
    }

    @Override
    public <J extends Job> void start(J job) {
        this.start(job, true);
    }

    @Override
    public <J extends Job> void start(J job, boolean async) {
        this.start(job, null, async);
    }

    @Override
    public synchronized <J extends Job> void start(J job, String lockId) {
        this.start(job, lockId, true);
    }

    @Override
    public synchronized <J extends Job> void start(final J job, final String lockId, boolean async) {
        this.jobInfoById.put(job.getId().toString(), new JobInfo(job));
        job.initialize();
        if (job.isPending()) {
            if (lockId != null) {
                this.lock(job, lockId);
            }
            Runnable jobRunnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        job.run();
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        if (lockId != null) {
                            SimpleJobManager.this.release(lockId);
                        }
                    }
                }
            };
            if (async) {
                this.jobExecutor.execute(jobRunnable);
            } else {
                jobRunnable.run();
            }
        }
    }

    protected <J extends Job> void lock(J job, String lockId) {
        if (this.jobByLockId.containsKey(lockId) && this.jobByLockId.get(lockId).isRunning()) {
            throw new RuntimeException("Another job is runnign for the same locking group: " + lockId);
        }
        this.jobByLockId.put(lockId, job);
    }

    public Job getJob(String jobId) {
        JobInfo jobInfo = this.jobInfoById.get(jobId);
        return jobInfo == null ? null : jobInfo.getJob();
    }

    public Job getLockingJob(String lockId) {
        return this.jobByLockId.get(lockId);
    }

    protected synchronized void release(String lockId) {
        this.jobByLockId.remove(lockId);
    }

    protected <J extends Job> void runJob(J job, String lockId) {
        try {
            job.run();
        }
        finally {
            if (lockId != null) {
                this.release(lockId);
            }
        }
    }

    public Executor getJobExecutor() {
        return this.jobExecutor;
    }

    protected void setJobExecutor(Executor jobExecutor) {
        this.jobExecutor = jobExecutor;
    }

    private synchronized void pruneIdleJobs() {
        Set<Map.Entry<String, JobInfo>> entrySet = this.jobInfoById.entrySet();
        Iterator<Map.Entry<String, JobInfo>> iterator = entrySet.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, JobInfo> entry = iterator.next();
            JobInfo jobInfo = entry.getValue();
            Job job = jobInfo.getJob();
            if (job.isRunning() || job.isPending()) continue;
            jobInfo.incrementIdleMillis(60000L);
            if (jobInfo.getIdleMillis() <= 1800000L) continue;
            iterator.remove();
        }
    }

    private class JobInfo {
        private Job job;
        private long idleMillis;

        public JobInfo(Job job) {
            this.job = job;
            this.idleMillis = 0L;
        }

        public Job getJob() {
            return this.job;
        }

        public long getIdleMillis() {
            return this.idleMillis;
        }

        public void incrementIdleMillis(long amount) {
            this.idleMillis += amount;
        }
    }
}

