/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.commons.io.csv;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.openforis.commons.io.csv.CsvReader;
import org.openforis.commons.io.csv.DateFormatException;
import org.openforis.commons.io.flat.FlatDataStream;
import org.openforis.commons.io.flat.FlatRecord;

public class CsvLine
implements FlatRecord {
    private Map<String, Integer> columns;
    private String[] line;
    private CsvReader csvReader;

    CsvLine(CsvReader csvReader, String[] line) {
        this.columns = csvReader.getColumnIndices();
        this.csvReader = csvReader;
        this.line = line;
    }

    public String[] getLine() {
        return this.line;
    }

    private String toString(String txt) {
        if (txt == null || txt.trim().isEmpty() || "NA".equals(txt)) {
            return null;
        }
        return txt;
    }

    private Integer toInteger(String val) {
        return this.isNullValue(val) ? null : Integer.valueOf(Double.valueOf(val).intValue());
    }

    private Double toDouble(String val) {
        return this.isNullValue(val) ? null : Double.valueOf(val);
    }

    private boolean isNullValue(String val) {
        return val == null || val.isEmpty() || "NA".equals(val);
    }

    private Boolean toBoolean(String val) {
        if (this.isNullValue(val)) {
            return null;
        }
        if (val.equals("1") || val.equalsIgnoreCase("T") || val.equalsIgnoreCase("Y") || val.equalsIgnoreCase("true")) {
            return true;
        }
        if (val.equals("0") || val.equalsIgnoreCase("F") || val.equalsIgnoreCase("N") || val.equalsIgnoreCase("false")) {
            return false;
        }
        throw new NumberFormatException("'" + val + "' is not a valid boolean value");
    }

    public Integer getColumnIndex(String column) {
        if (column == null) {
            throw new IllegalStateException("Column headers not yet read");
        }
        return this.columns.get(column);
    }

    private Date toDate(String val) {
        try {
            return this.isNullValue(val) ? null : this.csvReader.getDateFormat().parse(val);
        }
        catch (ParseException e) {
            throw DateFormatException.forInputString(val);
        }
    }

    public List<String> getColumnNames() {
        return Collections.unmodifiableList(new ArrayList<String>(this.columns.keySet()));
    }

    @Override
    public String[] toStringArray() {
        return this.line;
    }

    @Override
    public FlatDataStream getFlatDataStream() {
        return this.csvReader;
    }

    @Override
    public List<String> getFieldNames() {
        return this.csvReader.getColumnNames();
    }

    @Override
    public <T> T getValue(int idx, Class<T> type) {
        if (this.line.length <= idx) {
            return null;
        }
        String value = this.line[idx];
        if (type.isAssignableFrom(Integer.class)) {
            return (T)this.toInteger(value);
        }
        if (type.isAssignableFrom(Double.class)) {
            return (T)this.toDouble(value);
        }
        if (type.isAssignableFrom(Boolean.class)) {
            return (T)this.toBoolean(value);
        }
        if (type.isAssignableFrom(String.class)) {
            return (T)this.toString(value);
        }
        if (type.isAssignableFrom(Date.class)) {
            return (T)this.toDate(value);
        }
        throw new IllegalArgumentException("Unsupported type " + type);
    }

    @Override
    public <T> T getValue(String column, Class<T> type) {
        Integer idx = this.getColumnIndex(column);
        return idx == null ? null : (T)this.getValue(idx, type);
    }

    @Override
    public boolean isMissing(int idx) {
        return this.line[idx] == null || this.line[idx].equals("NA") || this.line[idx].trim().isEmpty();
    }

    @Override
    public boolean isMissing(String column) {
        Integer idx = this.getColumnIndex(column);
        return idx == null || this.isMissing(idx);
    }

    public String toString() {
        return Arrays.toString(this.line);
    }

    @Override
    public <T> T getValue(String column, Class<T> type, T defaultValue) {
        try {
            T val = this.getValue(column, type);
            if (val == null) {
                return defaultValue;
            }
            return val;
        }
        catch (DateFormatException e) {
            return defaultValue;
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }
}

