/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.commons.io.csv;

import java.io.IOException;
import java.util.List;
import org.openforis.commons.io.csv.CsvLine;
import org.openforis.commons.io.csv.CsvProcessor;
import org.openforis.commons.io.csv.CsvReader;
import org.openforis.commons.io.flat.FlatRecord;

public abstract class CsvReaderDelegate
extends CsvProcessor {
    protected boolean headersRead;
    protected long linesRead;
    protected CsvReader csvReader;

    public abstract int size() throws IOException;

    public abstract void close() throws IOException;

    public abstract void readHeaders() throws IOException;

    protected abstract String[] line(long var1) throws IOException;

    CsvReaderDelegate(CsvReader csvReader) {
        this.csvReader = csvReader;
        this.headersRead = false;
        this.linesRead = 0L;
    }

    public CsvLine readNextLine() throws IOException {
        if (!this.headersRead) {
            throw new IllegalStateException("Headers must be read first");
        }
        String[] line = this.line(this.linesRead);
        if (line == null) {
            return null;
        }
        ++this.linesRead;
        return new CsvLine(this.csvReader, line);
    }

    public final boolean isHeadersRead() {
        return this.headersRead;
    }

    public final long getLinesRead() {
        return this.linesRead;
    }

    public final List<String> getFieldNames() {
        return this.getColumnNames();
    }

    public final FlatRecord nextRecord() throws IOException {
        return this.readNextLine();
    }
}

