/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.commons.io.csv;

import au.com.bytecode.opencsv.CSVWriter;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.List;
import org.openforis.commons.io.csv.CsvProcessor;
import org.openforis.commons.io.flat.FlatDataStream;
import org.openforis.commons.io.flat.FlatRecord;

public class CsvWriter
extends CsvProcessor
implements Closeable {
    private static final char COMMA = ',';
    private static final char DEFAULT_SEPARATOR = ',';
    private CSVWriter csvWriter;
    private long linesWritten;
    private boolean headersWritten;

    public CsvWriter(Writer writer) {
        this(writer, ',', '\u0000');
    }

    public CsvWriter(Writer writer, char separator, char quotechar) {
        this.csvWriter = new CSVWriter(writer, separator, quotechar);
        this.linesWritten = 0L;
        this.headersWritten = false;
    }

    public CsvWriter(OutputStream out) throws UnsupportedEncodingException {
        this(out, "UTF-8", ',', '\u0000');
    }

    public CsvWriter(OutputStream out, String charsetName) throws UnsupportedEncodingException {
        this(out, charsetName, ',', '\u0000');
    }

    public CsvWriter(OutputStream out, String charsetName, char separator, char quotechar) throws UnsupportedEncodingException {
        this(new BufferedWriter(new OutputStreamWriter(out, charsetName)), separator, quotechar);
    }

    public void writeAll(FlatDataStream in) throws IOException {
        FlatRecord r = in.nextRecord();
        if (r == null) {
            return;
        }
        this.writeHeaders(in.getFieldNames());
        while (r != null) {
            this.writeNext(r);
            r = in.nextRecord();
        }
    }

    public void flush() throws IOException {
        this.csvWriter.flush();
    }

    @Override
    public void close() throws IOException {
        this.csvWriter.close();
    }

    public void writeNext(FlatRecord r) {
        String[] line = r.toStringArray();
        this.writeNext(line);
    }

    public void writeNext(List<String> line) {
        this.writeNext(line.toArray(new String[line.size()]));
    }

    public void writeNext(String[] line) {
        this.csvWriter.writeNext(line);
        ++this.linesWritten;
    }

    public void writeHeaders(List<String> headers) {
        this.writeHeaders(headers.toArray(new String[headers.size()]));
    }

    public void writeHeaders(String[] headers) {
        if (this.headersWritten) {
            throw new IllegalStateException("Headers already written");
        }
        this.setColumnNames(headers);
        this.csvWriter.writeNext(headers);
        this.headersWritten = true;
    }

    public long getLinesWritten() {
        return this.linesWritten;
    }

    public boolean isHeadersWritten() {
        return this.headersWritten;
    }
}

