/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.commons.io.csv;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.openforis.commons.io.csv.CsvReader;
import org.openforis.commons.io.csv.CsvReaderDelegate;

class ExcelReader
extends CsvReaderDelegate {
    private static final String DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private Sheet sheet;
    private int columnCount;
    private Workbook wb;

    public ExcelReader(File file, CsvReader csvReader) throws FileNotFoundException {
        super(csvReader);
        try {
            this.wb = WorkbookFactory.create((File)file);
            this.sheet = this.wb.getSheetAt(0);
        }
        catch (Exception e) {
            throw new ExcelParseException("Failed to parse " + file.getAbsolutePath() + " as Excel", e);
        }
    }

    @Override
    public void readHeaders() throws IOException {
        if (this.headersRead) {
            throw new IllegalStateException("Headers already read");
        }
        Row row = this.sheet.getRow(0);
        this.columnCount = row.getPhysicalNumberOfCells();
        String[] rowValues = this.extractValues(row);
        this.setColumnNames(rowValues);
        this.headersRead = true;
    }

    private String[] extractValues(Row row) {
        String[] rowValues = new String[this.columnCount];
        for (int colIdx = 0; colIdx < this.columnCount; ++colIdx) {
            rowValues[colIdx] = this.getCellStringValue(row, colIdx);
        }
        return rowValues;
    }

    private String getCellStringValue(Row row, int colIdx) {
        String value;
        Cell cell = row.getCell(colIdx);
        if (cell == null) {
            return "";
        }
        int cellType = cell.getCellType();
        if (cellType == 3) {
            value = "";
        } else if (cellType == 1) {
            value = cell.getStringCellValue();
        } else if (cellType == 0) {
            if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                Date date = cell.getDateCellValue();
                value = new SimpleDateFormat(DATE_TIME_FORMAT).format(date);
            } else {
                cell.setCellType(1);
                value = cell.getStringCellValue();
            }
        } else if (cellType == 4) {
            value = String.valueOf(cell.getBooleanCellValue());
        } else {
            cell.setCellType(1);
            value = cell.getStringCellValue();
        }
        return value;
    }

    @Override
    protected String[] line(long lineIdx) {
        Row row = this.sheet.getRow((int)lineIdx + 1);
        if (row == null) {
            return null;
        }
        String[] line = this.extractValues(row);
        return line;
    }

    @Override
    public void close() throws IOException {
        this.wb.close();
    }

    @Override
    public int size() throws IOException {
        return this.sheet.getPhysicalNumberOfRows();
    }

    static class ExcelParseException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ExcelParseException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

