/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.commons.lang;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.openforis.commons.lang.DeepComparable;
import org.openforis.commons.lang.IdentifiableDeepComparable;

public class Objects {
    public static <O extends Cloneable> List<O> clone(List<O> list) {
        if (list == null) {
            return null;
        }
        ArrayList<Cloneable> clone = new ArrayList<Cloneable>(list.size());
        for (O item : list) {
            Cloneable clonedItem = (Cloneable)ObjectUtils.cloneIfPossible(item);
            clone.add(clonedItem);
        }
        return clone;
    }

    public static <V> V getPropertyValue(Object obj, String propertyName) {
        try {
            Object value = FieldUtils.readField((Object)obj, (String)propertyName, (boolean)true);
            return (V)value;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean deepEquals(DeepComparable o1, DeepComparable o2) {
        return Objects.deepEquals(o1, o2, false);
    }

    public static boolean deepEquals(DeepComparable o1, DeepComparable o2, boolean ignoreId) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (o1 instanceof IdentifiableDeepComparable && o2 instanceof IdentifiableDeepComparable) {
            return ((IdentifiableDeepComparable)o1).deepEquals((IdentifiableDeepComparable)o2, ignoreId);
        }
        return o1.deepEquals(o2);
    }

    public static <T> T newInstance(Class<T> type, Object ... parameters) {
        ArrayList parameterTypes = new ArrayList();
        for (Object param : parameters) {
            parameterTypes.add(param.getClass());
        }
        try {
            Constructor<T> constructor = type.getDeclaredConstructor(parameterTypes.toArray(new Class[parameterTypes.size()]));
            return constructor.newInstance(parameters);
        }
        catch (Exception e) {
            return null;
        }
    }
}

