/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.commons.web;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.validation.ObjectError;

public class Response {
    private Status status;
    private Object object;
    private Map<String, Object> objects = new HashMap<String, Object>();
    private String errorMessage;
    private List<ObjectError> errors;

    public Response() {
        this(null);
    }

    public Response(List<ObjectError> errors) {
        if (errors != null && !errors.isEmpty()) {
            this.setStatus(Status.ERROR);
            this.errors = errors;
        } else {
            this.setStatus(Status.OK);
            this.errors = new ArrayList<ObjectError>();
        }
    }

    public Status getStatus() {
        return this.status;
    }

    void setStatus(Status status) {
        this.status = status;
    }

    public boolean isStatusOk() {
        return this.status == Status.OK;
    }

    public void setOkStatus() {
        this.setStatus(Status.OK);
    }

    public boolean isStatusError() {
        return this.status == Status.ERROR;
    }

    public void setErrorStatus() {
        this.setStatus(Status.ERROR);
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public List<ObjectError> getErrors() {
        return this.errors;
    }

    void addError(ObjectError objectError) {
        this.errors.add(objectError);
    }

    public boolean hasErrors() {
        return this.status == Status.ERROR;
    }

    public Object getObject() {
        return this.object;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public Map<String, Object> getObjects() {
        return this.objects;
    }

    public void addObject(String key, Object object) {
        this.objects.put(key, object);
    }

    public static enum Status {
        OK,
        ERROR;

    }
}

