/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.commons.collection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.openforis.commons.collection.CollectionUtils;

public class Tree<T> {
    private Node<T> root;
    private Map<T, Node<T>> itemToNode = new HashMap<T, Node<T>>();

    public Tree() {
        this(null);
    }

    public Tree(T rootItem) {
        this.root = this.createNode(rootItem);
        this.itemToNode.put(rootItem, this.root);
    }

    public Node<T> getRoot() {
        return this.root;
    }

    public Node<T> findNodeByItem(T item) {
        return this.itemToNode.get(item);
    }

    public void reparent(Node<T> node, Node<T> newParent) {
        ((Node)node).parent.removeChild(node);
        newParent.addChild(node);
    }

    public List<T> getItems() {
        final ArrayList result = new ArrayList();
        this.traverse(new NodeVisitor<T>(){

            @Override
            public void visit(Node<T> node) {
                Object item = node.item;
                if (item != null) {
                    result.add(item);
                }
            }
        }, TraversalType.BFS);
        return result;
    }

    public void traverse(NodeVisitor<T> visitor) {
        this.traverse(visitor, TraversalType.DFS);
    }

    public void traverse(NodeVisitor<T> visitor, TraversalType traversalType) {
        switch (traversalType) {
            case BFS: {
                this.bfsTraverse(visitor);
                break;
            }
            default: {
                this.dfsTraverse(visitor);
            }
        }
    }

    protected void dfsTraverse(NodeVisitor<T> visitor) {
        Stack<Node<T>> stack = new Stack<Node<T>>();
        stack.push(this.root);
        while (!stack.isEmpty()) {
            Node node = (Node)stack.pop();
            visitor.visit(node);
            stack.addAll(node.children);
        }
    }

    protected void bfsTraverse(NodeVisitor<T> visitor) {
        LinkedList queue = new LinkedList();
        queue.add(this.root);
        while (!queue.isEmpty()) {
            Node node = (Node)queue.poll();
            visitor.visit(node);
            queue.addAll(node.getChildren());
        }
    }

    public Node<T> createNode(T item) {
        return new Node(this, item);
    }

    public static class Node<T> {
        private Tree<T> tree;
        private Node<T> parent;
        private T item;
        private List<Node<T>> children;

        private Node(Tree<T> tree) {
            this.tree = tree;
            this.children = new ArrayList<Node<T>>();
        }

        private Node(Tree<T> tree, T item) {
            this(tree);
            this.item = item;
        }

        public void addChild(Node<T> node) {
            this.children.add(node);
            node.parent = this;
            ((Tree)this.tree).itemToNode.put(node.item, node);
        }

        public void removeChild(Node<T> node) {
            this.children.remove(node);
            node.parent = null;
            ((Tree)this.tree).itemToNode.remove(node.item);
        }

        public List<Node<T>> getChildren() {
            return CollectionUtils.unmodifiableList(this.children);
        }

        public int getDepth() {
            Node<T> currentParent = this.parent;
            int result = 0;
            while (currentParent != null) {
                ++result;
                currentParent = currentParent.parent;
            }
            return result;
        }

        public boolean isDetached() {
            return this.parent == null;
        }
    }

    public static interface NodeVisitor<T> {
        public void visit(Node<T> var1);
    }

    public static enum TraversalType {
        BFS,
        DFS;

    }
}

