/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.commons.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;
import org.openforis.commons.collection.Predicate;
import org.openforis.commons.collection.Transformer;
import org.openforis.commons.lang.DeepComparable;
import org.openforis.commons.lang.Objects;

public abstract class CollectionUtils {
    public static <T> List<T> unmodifiableList(List<? extends T> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(list);
    }

    public static <T> Set<T> unmodifiableSet(Set<? extends T> set) {
        if (set == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(set);
    }

    public static <K, V> Map<K, V> unmodifiableMap(Map<? extends K, ? extends V> map) {
        if (map == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(map);
    }

    public static <T> Collection<T> unmodifiableCollection(Collection<? extends T> collection) {
        if (collection == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(collection);
    }

    public static <T> void shiftItem(List<T> list, T item, int toIndex) {
        int oldIndex = list.indexOf(item);
        if (oldIndex < 0) {
            throw new IllegalArgumentException("Item not found");
        }
        if (toIndex < 0 || toIndex >= list.size()) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + toIndex + " (list size = " + list.size() + ")");
        }
        list.remove(oldIndex);
        list.add(toIndex, item);
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return collection != null && !collection.isEmpty();
    }

    public static <T, C extends Collection<T>> void filter(C collection, Predicate<T> predicate) {
        if (collection != null && predicate != null) {
            Iterator<T> it = collection.iterator();
            while (it.hasNext()) {
                T item = it.next();
                if (predicate.evaluate(item)) continue;
                it.remove();
            }
        }
    }

    public static <T, C extends Collection<T>> List<T> filterIntoList(C collection, Predicate<T> predicate) {
        ArrayList<T> result = new ArrayList<T>();
        if (collection != null && predicate != null) {
            for (T item : collection) {
                if (!predicate.evaluate(item)) continue;
                result.add(item);
            }
        }
        return result;
    }

    public static <T> T find(Collection<T> items, Predicate<T> predicate) {
        for (T item : items) {
            if (!predicate.evaluate(item)) continue;
            return item;
        }
        return null;
    }

    public static <T> T findItem(Collection<T> items, Object key) {
        return CollectionUtils.findItem(items, key, "id");
    }

    public static <T> T findItem(Collection<T> items, Object key, String keyPropertyName) {
        for (T item : items) {
            Object keyValue = Objects.getPropertyValue(item, (String)keyPropertyName);
            if (!key.equals(keyValue)) continue;
            return item;
        }
        return null;
    }

    public static <T> Collection<T> addIgnoreNull(Collection<T> items, T item) {
        if (item != null) {
            items.add(item);
        }
        return items;
    }

    public static <I, T> List<I> project(Collection<T> items, String propertyName) {
        ArrayList<Object> result = new ArrayList<Object>(items.size());
        for (T item : items) {
            Object keyValue = Objects.getPropertyValue(item, (String)propertyName);
            result.add(keyValue);
        }
        return result;
    }

    public static <T extends DeepComparable> boolean deepEquals(Collection<T> coll1, Collection<T> coll2) {
        return CollectionUtils.deepEquals(coll1, coll2, false);
    }

    public static <T extends DeepComparable> boolean deepEquals(Collection<T> coll1, Collection<T> coll2, boolean ignoreId) {
        if (coll1 == coll2) {
            return true;
        }
        Iterator<T> e1 = coll1.iterator();
        Iterator<T> e2 = coll2.iterator();
        while (e1.hasNext() && e2.hasNext()) {
            DeepComparable o2;
            DeepComparable o1 = (DeepComparable)e1.next();
            if (Objects.deepEquals((DeepComparable)o1, (DeepComparable)(o2 = (DeepComparable)e2.next()), (boolean)ignoreId)) continue;
            return false;
        }
        return !e1.hasNext() && !e2.hasNext();
    }

    public static <T> List<T> clone(List<T> list) {
        if (list == null) {
            return null;
        }
        if (list instanceof ArrayList) {
            return (List)((ArrayList)list).clone();
        }
        ArrayList<T> result = new ArrayList<T>(list.size());
        for (T item : list) {
            result.add(item);
        }
        return result;
    }

    public static <K, V> void cloneValuesInto(Map<K, V> fromMap, Map<K, V> intoMap) {
        for (Map.Entry<K, V> entry : fromMap.entrySet()) {
            intoMap.put(ObjectUtils.cloneIfPossible(entry.getKey()), ObjectUtils.cloneIfPossible(entry.getValue()));
        }
    }

    public static <T> List<T> copyAndFillWithNulls(List<T> list, int newSize) {
        return CollectionUtils.copyAndFillWith(list, newSize, null);
    }

    public static <T> List<T> copyAndFillWith(List<T> list, int newSize, T fillValue) {
        if (list.size() > newSize) {
            throw new IllegalArgumentException(String.format("Original collection size (%d) must not exceed the new collection size: %d", list.size(), newSize));
        }
        ArrayList<T> result = new ArrayList<T>(newSize);
        result.addAll(list);
        result.addAll(Collections.nCopies(newSize - list.size(), fillValue));
        return result;
    }

    public static <T> Set<T> intersect(Collection<T> listA, Collection<T> listB) {
        LinkedHashSet<T> result = new LinkedHashSet<T>();
        for (T item : listA) {
            if (!listB.contains(item)) continue;
            result.add(item);
        }
        return result;
    }

    public static <T> List<Integer> indexOfItems(List<T> list, Collection<T> items) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (T item : items) {
            int index = list.indexOf(item);
            if (index < 0) continue;
            result.add(index);
        }
        return result;
    }

    public static <T> List<T> sublistByIndexes(List<T> source, List<Integer> indexes) {
        ArrayList<T> result = new ArrayList<T>();
        for (Integer index : indexes) {
            result.add(source.get(index));
        }
        return result;
    }

    public static <T> List<T> map(Collection<T> collection, Transformer<T> transformer) {
        ArrayList<T> result = new ArrayList<T>();
        if (collection == null || transformer == null) {
            return result;
        }
        for (T item : collection) {
            T transformedItem = transformer.transform(item);
            result.add(transformedItem);
        }
        return result;
    }
}

