/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.concurrency.spring;

import java.util.concurrent.Executor;
import org.openforis.concurrency.Job;
import org.openforis.concurrency.JobManager;
import org.openforis.concurrency.SimpleJobManager;
import org.openforis.concurrency.Worker;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SpringJobManager
extends SimpleJobManager
implements BeanFactoryAware {
    private BeanFactory beanFactory;

    protected <T extends Worker> T createInstance(Class<T> type) throws InstantiationException, IllegalAccessException {
        return (T)((Worker)this.beanFactory.getBean(type));
    }

    protected <T extends Worker> T createInstance(String name, Class<T> type) {
        return (T)((Worker)this.beanFactory.getBean(name, type));
    }

    public <J extends Job> J createJob(String name, Class<J> type) {
        Job job = (Job)this.createInstance(name, type);
        job.setJobManager((JobManager)this);
        return (J)job;
    }

    @Autowired
    protected void setJobExecutor(Executor jobExecutor) {
        super.setJobExecutor(jobExecutor);
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }
}

