/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.concurrency;

import org.openforis.concurrency.Progress;

public class ProcessProgressListener {
    private int totalSteps = 0;
    private int currentStep = 0;
    private Progress[] progressPerStep;

    public ProcessProgressListener(int totalSteps) {
        this.totalSteps = totalSteps;
        this.progressPerStep = new Progress[totalSteps];
    }

    public void stepProgressMade(Progress stepProgress) {
        this.progressPerStep[this.currentStep] = stepProgress;
    }

    public void stepCompleted() {
        ++this.currentStep;
    }

    private long sum(Long ... values) {
        long total = 0L;
        for (Long value : values) {
            if (value == null) continue;
            total += value.longValue();
        }
        return total;
    }

    public Progress getProgress() {
        Long[] stepProgressPercents = new Long[this.totalSteps];
        for (int i = 0; i <= this.currentStep; ++i) {
            Progress stepProgress = this.progressPerStep[i];
            if (stepProgress == null) continue;
            stepProgressPercents[i] = stepProgress.getCompletionPercent();
        }
        return new Progress(this.sum(stepProgressPercents), this.totalSteps * 100);
    }
}

