/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.concurrency;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.openforis.concurrency.Processor;

public abstract class BatchProcessor<T>
implements Processor<T>,
Closeable {
    private final int batchSize;
    private final Executor<T> executor;
    private final LinkedList<T> queue = new LinkedList();

    public BatchProcessor(int batchSize, Executor<T> executor) {
        this.batchSize = batchSize;
        this.executor = executor;
    }

    @Override
    public void process(T item) {
        this.queue.add(item);
        if (this.queue.size() == this.batchSize) {
            this.flush();
        }
    }

    @Override
    public void process(Collection<T> items) {
        for (T item : items) {
            this.process(item);
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
    }

    private void flush() {
        if (!this.queue.isEmpty()) {
            this.executor.execute(this.queue);
            this.queue.clear();
        }
    }

    public static interface Executor<T> {
        public void execute(List<T> var1);
    }
}

