/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.concurrency;

import org.openforis.concurrency.Worker;

public abstract class Task
extends Worker {
    private long totalItems = -1L;
    private long processedItems = 0L;
    private long skippedItems = 0L;

    @Override
    protected void beforeExecuteInternal() throws Throwable {
        super.beforeExecuteInternal();
        this.totalItems = this.countTotalItems();
    }

    protected long countTotalItems() {
        return -1L;
    }

    protected void setProcessedItems(long processedItems) {
        this.processedItems = processedItems;
    }

    public void setTotalItems(long totalItems) {
        this.totalItems = totalItems;
    }

    protected long incrementProcessedItems() {
        return ++this.processedItems;
    }

    protected long incrementSkippedItems() {
        return ++this.skippedItems;
    }

    public long getRemainingItems() {
        return this.totalItems - (this.processedItems + this.skippedItems);
    }

    @Override
    public int getProgressPercent() {
        switch (this.getStatus()) {
            case COMPLETED: {
                return 100;
            }
            case PENDING: {
                return 0;
            }
        }
        if (this.totalItems > 0L) {
            int result = Double.valueOf(Math.ceil((double)(this.processedItems + this.skippedItems) * 100.0 / (double)this.totalItems)).intValue();
            return result;
        }
        return 0;
    }

    public long getProcessedItems() {
        return this.processedItems;
    }

    public long getSkippedItems() {
        return this.skippedItems;
    }

    public long getTotalItems() {
        return this.totalItems;
    }
}

