/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.concurrency;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openforis.concurrency.WorkerStatusChangeEvent;
import org.openforis.concurrency.WorkerStatusChangeListener;

public abstract class Worker {
    private UUID id = UUID.randomUUID();
    private long startTime = -1L;
    private long endTime = -1L;
    private Status status = Status.PENDING;
    private String errorMessage;
    private String[] errorMessageArgs;
    private int weight = 1;
    private transient Throwable lastException;
    private transient Logger log;
    private transient List<WorkerStatusChangeListener> statusChangeListeners = new ArrayList<WorkerStatusChangeListener>();
    private Map<String, Object> result;

    public void initialize() {
        this.logDebug("Initializing...");
        try {
            this.validateInput();
            if (this.isPending()) {
                this.createInternalVariables();
                if (this.isPending()) {
                    this.initializeInternalVariables();
                }
            }
        }
        catch (Throwable t) {
            this.handleException(t);
        }
    }

    protected void validateInput() throws Throwable {
    }

    protected void createInternalVariables() throws Throwable {
    }

    protected void initializeInternalVariables() throws Throwable {
    }

    protected void beforeExecute() {
        this.logDebug("Before executing...");
        try {
            this.startTime = System.currentTimeMillis();
            this.beforeExecuteInternal();
            this.changeStatus(Status.RUNNING);
        }
        catch (Throwable t) {
            this.handleException(t);
        }
    }

    protected void beforeExecuteInternal() throws Throwable {
    }

    protected abstract void execute() throws Throwable;

    protected void afterExecute() {
        this.logDebug("After executing...");
        try {
            this.afterExecuteInternal();
            if (this.isRunning()) {
                this.changeStatus(Status.COMPLETED);
            }
        }
        catch (Throwable t) {
            this.handleException(t);
        }
    }

    protected void afterExecuteInternal() {
    }

    public void addStatusChangeListener(WorkerStatusChangeListener listener) {
        this.statusChangeListeners.add(listener);
    }

    public void removeStatusChangeListener(WorkerStatusChangeListener listener) {
        this.statusChangeListeners.remove(listener);
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    protected synchronized void run() {
        if (!this.isPending()) {
            throw new IllegalStateException("Already run");
        }
        try {
            this.beforeExecute();
            this.execute();
            this.afterExecute();
        }
        catch (Throwable t) {
            try {
                this.handleException(t);
            }
            catch (Throwable throwable) {
                this.endTime = System.currentTimeMillis();
                this.notifyAll();
                this.logDebug(String.format("Finished in %.1f sec", Float.valueOf((float)this.getDuration() / 1000.0f)));
                this.onEnd();
                throw throwable;
            }
            this.endTime = System.currentTimeMillis();
            this.notifyAll();
            this.logDebug(String.format("Finished in %.1f sec", Float.valueOf((float)this.getDuration() / 1000.0f)));
            this.onEnd();
        }
        this.endTime = System.currentTimeMillis();
        this.notifyAll();
        this.logDebug(String.format("Finished in %.1f sec", Float.valueOf((float)this.getDuration() / 1000.0f)));
        this.onEnd();
    }

    public void abort() {
        this.changeStatus(Status.ABORTED);
        this.release();
    }

    protected void changeStatus(Status newStatus) {
        Status oldStatus = this.status;
        WorkerStatusChangeEvent event = new WorkerStatusChangeEvent(this, oldStatus, newStatus);
        this.status = newStatus;
        this.notifyAllStatusChangeListeners(event);
        switch (newStatus) {
            case COMPLETED: {
                this.prepareResult();
                this.onCompleted();
                break;
            }
            case FAILED: {
                this.onFailed();
                break;
            }
            case ABORTED: {
                this.onAborted();
                break;
            }
        }
    }

    protected Map<String, Object> prepareResult() {
        this.result = new HashMap<String, Object>();
        return this.result;
    }

    protected void onEnd() {
    }

    protected void onCompleted() {
    }

    protected void onFailed() {
    }

    protected void onAborted() {
    }

    public void destroy() {
        if (this.isRunning()) {
            this.abort();
        }
        this.release();
    }

    protected void release() {
    }

    protected void notifyAllStatusChangeListeners(WorkerStatusChangeEvent event) {
        for (WorkerStatusChangeListener listener : this.statusChangeListeners) {
            listener.statusChanged(event);
        }
    }

    public long getDuration() {
        switch (this.status) {
            case PENDING: {
                return -1L;
            }
            case RUNNING: {
                return System.currentTimeMillis() - this.startTime;
            }
        }
        return this.endTime - this.startTime;
    }

    private void handleException(Throwable t) {
        this.logError(String.format("Error running worker (status: %s): %s", this.status.name(), t.getMessage()), t);
        this.lastException = t;
        this.errorMessage = t.getMessage();
        this.changeStatus(Status.FAILED);
    }

    public boolean isPending() {
        return this.status == null || this.status == Status.PENDING;
    }

    public boolean isRunning() {
        return this.status == Status.RUNNING;
    }

    public boolean isFailed() {
        return this.status == Status.FAILED;
    }

    public boolean isAborted() {
        return this.status == Status.ABORTED;
    }

    public boolean isCompleted() {
        return this.status == Status.COMPLETED;
    }

    public abstract int getProgressPercent();

    public boolean isEnded() {
        return this.status != Status.PENDING && this.status != Status.RUNNING;
    }

    public Status getStatus() {
        return this.status;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public Throwable getLastException() {
        return this.lastException;
    }

    public UUID getId() {
        return this.id;
    }

    private Logger log() {
        if (this.log == null) {
            this.log = Logger.getLogger(this.getClass().getName());
        }
        return this.log;
    }

    protected void logDebug(String message) {
        this.log().log(Level.FINE, message);
    }

    protected void logInfo(String message) {
        this.log().log(Level.INFO, message);
    }

    protected void logWarning(String message) {
        this.log().log(Level.WARNING, message);
    }

    protected void logError(String message, Throwable throwable) {
        this.log().log(Level.SEVERE, message, throwable);
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    protected void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String[] getErrorMessageArgs() {
        return this.errorMessageArgs;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public Map<String, Object> getResult() {
        return this.result;
    }

    public void setResult(Map<String, Object> result) {
        this.result = result;
    }

    protected void setErrorMessageArgs(String[] errorMessageArgs) {
        this.errorMessageArgs = errorMessageArgs;
    }

    protected void setLastException(Throwable lastException) {
        this.lastException = lastException;
    }

    public synchronized boolean waitFor(int timeoutMillis) {
        long start = System.currentTimeMillis();
        while (!this.isEnded() && System.currentTimeMillis() - start < (long)timeoutMillis) {
            try {
                this.wait(timeoutMillis);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.isCompleted();
    }

    public static enum Status {
        PENDING,
        RUNNING,
        COMPLETED,
        FAILED,
        ABORTED;

    }
}

