/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.commons.io.csv;

import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.openforis.commons.io.csv.CsvLine;
import org.openforis.commons.io.csv.CsvProcessor;
import org.openforis.commons.io.csv.CsvReader;
import org.openforis.commons.io.flat.Field;
import org.openforis.commons.io.flat.FlatRecord;

public abstract class CsvReaderDelegate
extends CsvProcessor {
    protected boolean headersRead;
    protected long linesRead;
    protected CsvReader csvReader;

    CsvReaderDelegate(CsvReader csvReader) {
        this.csvReader = csvReader;
        this.headersRead = false;
        this.linesRead = 0L;
    }

    public abstract int size() throws IOException;

    public abstract void close() throws IOException;

    public abstract String[] readHeadersInternal() throws IOException;

    protected abstract String[] line(long var1) throws IOException;

    public CsvLine readNextLine() throws IOException {
        if (!this.headersRead) {
            throw new IllegalStateException("Headers must be read first");
        }
        String[] line = this.line(this.linesRead);
        if (line == null) {
            return null;
        }
        ++this.linesRead;
        return new CsvLine(this.csvReader, line);
    }

    public void readHeaders() throws IOException {
        if (this.headersRead) {
            throw new IllegalStateException("Headers already read");
        }
        String[] headers = this.readHeadersInternal();
        headers = this.adjustHeaders(headers);
        this.setFieldNames(headers);
        this.headersRead = true;
    }

    private String[] adjustHeaders(String[] headers) {
        String[] stringArray;
        int count;
        if (headers == null) {
            return null;
        }
        String[] result = null;
        for (count = headers.length; count > 0 && StringUtils.isBlank((CharSequence)headers[count - 1]); --count) {
        }
        if (count < headers.length) {
            headers = (String[])ArrayUtils.subarray((Object[])headers, (int)0, (int)count);
            stringArray = headers;
        } else {
            stringArray = headers;
        }
        result = stringArray;
        for (int i = 0; i < count; ++i) {
            result[i] = result[i].trim();
        }
        return result;
    }

    public final boolean isHeadersRead() {
        return this.headersRead;
    }

    public final long getLinesRead() {
        return this.linesRead;
    }

    @Override
    public final List<Field> getFields() {
        return super.getFields();
    }

    @Override
    public final List<String> getFieldNames() {
        return super.getFieldNames();
    }

    public final FlatRecord nextRecord() throws IOException {
        return this.readNextLine();
    }

    public void setHeadersRead(boolean headersRead) {
        this.headersRead = headersRead;
    }
}

