/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.commons.io.csv;

import au.com.bytecode.opencsv.CSVWriter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.openforis.commons.io.flat.FlatDataWriter;

public class CsvWriter
extends FlatDataWriter {
    private static final char COMMA = ',';
    private static final char DEFAULT_SEPARATOR = ',';
    private CSVWriter csvWriter;

    public CsvWriter(Writer writer) {
        this(writer, ',', '\u0000');
    }

    public CsvWriter(OutputStream out) throws UnsupportedEncodingException {
        this(out, "UTF-8", ',', '\u0000');
    }

    public CsvWriter(OutputStream out, String charsetName) throws UnsupportedEncodingException {
        this(out, charsetName, ',', '\u0000');
    }

    public CsvWriter(OutputStream out, String charsetName, char separator, char quotechar) throws UnsupportedEncodingException {
        this(new BufferedWriter(new OutputStreamWriter(out, charsetName)), separator, quotechar);
    }

    public CsvWriter(Writer writer, char separator, char quoteChar) {
        this.csvWriter = new CSVWriter(writer, separator, quoteChar);
    }

    @Override
    protected void writeNextInternal(Object[] values) {
        String[] stringValues = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            String stringVal;
            Object val = values[i];
            stringValues[i] = stringVal = val == null ? null : val.toString();
        }
        this.csvWriter.writeNext(stringValues);
    }

    @Override
    public void flush() throws IOException {
        this.csvWriter.flush();
    }

    @Override
    public void close() throws IOException {
        this.csvWriter.close();
    }
}

