/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.commons.io.csv;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.text.DateFormat;
import java.util.List;
import org.openforis.commons.io.csv.CsvLine;
import org.openforis.commons.io.csv.CsvProcessor;
import org.openforis.commons.io.csv.CsvReaderDelegate;
import org.openforis.commons.io.csv.ExcelReader;
import org.openforis.commons.io.csv.OpenCsvReader;
import org.openforis.commons.io.flat.Field;
import org.openforis.commons.io.flat.FlatDataStream;
import org.openforis.commons.io.flat.FlatRecord;

public class CsvReader
extends CsvProcessor
implements FlatDataStream,
Closeable {
    private final CsvReaderDelegate delegate;
    private IOException delegateConstructionException;
    public static final char DEFAULT_SEPARATOR = ',';
    public static final char DEFAULT_QUOTE_CHARACTER = '\"';

    public CsvReader(String filename) throws FileNotFoundException {
        this(filename, ',', '\"');
    }

    public CsvReader(String fileName, char separator, char quoteChar) throws FileNotFoundException {
        this(new File(fileName), separator, quoteChar);
    }

    public CsvReader(File file) throws FileNotFoundException {
        this(file, "UTF-8", ',', '\"');
    }

    public CsvReader(File file, char separator, char quoteChar) throws FileNotFoundException {
        this(file, "UTF-8", separator, quoteChar);
    }

    public CsvReader(File file, String charsetName, char separator, char quoteChar) throws FileNotFoundException {
        this.delegate = CsvReader.createDelegate(file, charsetName, separator, quoteChar, this);
    }

    @Deprecated
    public CsvReader(Reader reader) {
        this(reader, ',', '\"');
    }

    @Deprecated
    public CsvReader(Reader reader, char separator, char quoteChar) {
        this.delegate = new OpenCsvReader(reader, separator, quoteChar, this);
    }

    private static CsvReaderDelegate createDelegate(File file, String charsetName, char separator, char quoteChar, CsvReader csvReader) throws FileNotFoundException {
        try {
            return new ExcelReader(file, csvReader);
        }
        catch (ExcelReader.ExcelParseException e) {
            try {
                return new OpenCsvReader(file, charsetName, separator, quoteChar, csvReader);
            }
            catch (IOException ex) {
                csvReader.delegateConstructionException = ex;
                return null;
            }
        }
    }

    public void readHeaders() throws IOException {
        this.checkDelegate();
        this.delegate.readHeaders();
    }

    public CsvLine readNextLine() throws IOException {
        return this.delegate.readNextLine();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    public boolean isHeadersRead() {
        return this.delegate.isHeadersRead();
    }

    public void setHeadersRead(boolean headersRead) {
        this.delegate.setHeadersRead(headersRead);
    }

    public long getLinesRead() {
        return this.delegate.getLinesRead();
    }

    @Override
    public List<Field> getFields() {
        return this.delegate.getFields();
    }

    @Override
    public List<String> getFieldNames() {
        return this.delegate.getFieldNames();
    }

    @Override
    public FlatRecord nextRecord() throws IOException {
        return this.delegate.nextRecord();
    }

    public List<String> getColumnNames() {
        return this.getFieldNames();
    }

    @Override
    public DateFormat getDateFormat() {
        return this.delegate.getDateFormat();
    }

    public int size() throws IOException {
        return this.delegate.size();
    }

    private void checkDelegate() throws IOException {
        if (this.delegate == null) {
            throw this.delegateConstructionException;
        }
    }
}

