/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.commons.io.flat;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import org.openforis.commons.io.csv.CsvProcessor;
import org.openforis.commons.io.flat.Field;
import org.openforis.commons.io.flat.FlatDataStream;
import org.openforis.commons.io.flat.FlatRecord;

public abstract class FlatDataWriter
extends CsvProcessor
implements Closeable {
    protected long linesWritten = 0L;
    protected boolean headersWritten = false;

    public void writeAll(FlatDataStream in) throws IOException {
        FlatRecord r = in.nextRecord();
        if (r == null) {
            return;
        }
        this.setFields(in.getFields());
        while (r != null) {
            this.writeNext(r);
            r = in.nextRecord();
        }
    }

    public abstract void flush() throws IOException;

    @Override
    public abstract void close() throws IOException;

    public void writeNext(FlatRecord r) {
        Object[] line = r.toArray();
        this.writeNext(line);
    }

    public void writeNext(List<String> line) {
        this.writeNext(line.toArray(new Object[line.size()]));
    }

    public void writeNext(Object[] line) {
        this.writeNextInternal(line);
        ++this.linesWritten;
    }

    protected abstract void writeNextInternal(Object[] var1);

    public void writeHeaders(List<String> headers) {
        this.writeHeaders(headers.toArray(new String[headers.size()]));
    }

    public void writeHeaders(Field[] fields) {
        if (this.headersWritten) {
            throw new IllegalStateException("Headers already written");
        }
        this.setFields(fields);
        Object[] headers = new String[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            headers[i] = field.getName();
        }
        this.writeNext(headers);
        this.headersWritten = true;
    }

    public void writeHeaders(String[] headers) {
        Field[] fields = new Field[headers.length];
        for (int i = 0; i < headers.length; ++i) {
            fields[i] = new Field(headers[i], Field.Type.STRING, i);
        }
        this.writeHeaders(fields);
    }

    public long getLinesWritten() {
        return this.linesWritten;
    }

    public boolean isHeadersWritten() {
        return this.headersWritten;
    }
}

