/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.commons.io.csv;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.openforis.commons.io.csv.CsvReader;
import org.openforis.commons.io.csv.CsvReaderDelegate;

class ExcelReader
extends CsvReaderDelegate {
    private static final String DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private Sheet sheet;
    private int columnCount;
    private Workbook wb;

    public ExcelReader(File file, CsvReader csvReader) throws FileNotFoundException {
        super(csvReader);
        try {
            this.wb = WorkbookFactory.create((File)file);
            this.sheet = this.wb.getSheetAt(0);
        }
        catch (Exception e) {
            throw new ExcelParseException("Failed to parse " + file.getAbsolutePath() + " as Excel", e);
        }
    }

    @Override
    public String[] readHeadersInternal() throws IOException {
        Row row = this.sheet.getRow(0);
        this.columnCount = row.getPhysicalNumberOfCells();
        return this.extractValues(row);
    }

    @Override
    public void readHeaders() throws IOException {
        super.readHeaders();
        this.columnCount = this.getFieldNames() == null ? 0 : this.getFieldNames().size();
    }

    private String[] extractValues(Row row) {
        String[] rowValues = new String[this.columnCount];
        for (int colIdx = 0; colIdx < this.columnCount; ++colIdx) {
            rowValues[colIdx] = this.getCellStringValue(row, colIdx);
        }
        return rowValues;
    }

    private String getCellStringValue(Row row, int colIdx) {
        Cell cell = row.getCell(colIdx);
        if (cell == null) {
            return "";
        }
        switch (cell.getCellType()) {
            case NUMERIC: {
                return this.getNumericStringValue(cell);
            }
            case BOOLEAN: {
                return String.valueOf(cell.getBooleanCellValue());
            }
        }
        cell.setCellType(CellType.STRING);
        return cell.getStringCellValue();
    }

    private String getNumericStringValue(Cell cell) {
        if (DateUtil.isCellDateFormatted((Cell)cell)) {
            Date date = cell.getDateCellValue();
            return new SimpleDateFormat(DATE_TIME_FORMAT).format(date);
        }
        double doubleVal = cell.getNumericCellValue();
        Double doubleValObj = doubleVal;
        if (doubleVal % 1.0 == 0.0 && doubleVal < 2.147483647E9) {
            return String.valueOf(doubleValObj.intValue());
        }
        return String.valueOf(doubleVal);
    }

    @Override
    protected String[] line(long lineIdx) {
        Row row = this.sheet.getRow((int)lineIdx + 1);
        if (row == null) {
            return null;
        }
        return this.extractValues(row);
    }

    @Override
    public void close() throws IOException {
        if (this.wb != null) {
            this.wb.close();
        }
    }

    @Override
    public int size() throws IOException {
        return this.sheet.getPhysicalNumberOfRows();
    }

    static class ExcelParseException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ExcelParseException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

