/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.commons.io.excel;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.openforis.commons.io.excel.ExcelPictures;
import org.openforis.commons.io.flat.Field;
import org.openforis.commons.io.flat.FlatDataWriter;

public class ExcelFlatValuesWriter
extends FlatDataWriter {
    private static final int IMAGE_COLUMN_WIDTH = 4000;
    private static final short IMAGE_ROW_HEIGHT = 2000;
    private Workbook workbook = new XSSFWorkbook();
    private Sheet sheet = this.workbook.createSheet("sheet1");
    private OutputStream os;

    public ExcelFlatValuesWriter(OutputStream output) throws UnsupportedEncodingException {
        this.os = output;
    }

    @Override
    protected void writeNextInternal(Object[] values) {
        Row row = this.sheet.createRow(Long.valueOf(this.linesWritten).intValue());
        for (int i = 0; i < this.getFields().size() && i < values.length; ++i) {
            Cell cell = row.createCell(i);
            Field field = this.getFields().get(i);
            switch (field.getType()) {
                case DECIMAL: 
                case INTEGER: {
                    cell.setCellType(CellType.NUMERIC);
                    break;
                }
                default: {
                    cell.setCellType(CellType.STRING);
                }
            }
            this.setValueIntoCell(cell, field, values[i]);
        }
    }

    protected void setValueIntoCell(Cell cell, Field field, Object value) {
        if (value == null) {
            cell.setCellValue((String)null);
        } else {
            Field.Type fieldType = field.getType();
            if (value instanceof Number && (fieldType == Field.Type.DECIMAL || fieldType == Field.Type.INTEGER)) {
                cell.setCellValue(((Number)value).doubleValue());
            } else if (fieldType == Field.Type.IMAGE_BYTE_ARRAY) {
                this.sheet.setColumnWidth(cell.getColumnIndex(), 4000);
                cell.getRow().setHeight((short)2000);
                ExcelPictures.addPicture(this.sheet, (byte[])value, 5, cell);
            } else {
                cell.setCellValue(value.toString());
            }
        }
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        if (this.workbook != null) {
            this.workbook.write(this.os);
            this.workbook.close();
        }
    }
}

